/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.configurationdata.particles.shapes;

import java.util.ArrayList;
import java.util.List;
import me.xemor.superheroes.configurationdata.JsonPropertyWithDefault;
import me.xemor.superheroes.configurationdata.particles.EntityShape;
import me.xemor.superheroes.configurationdata.particles.shapes.Shape;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class Ears
extends Shape
implements EntityShape {
    @JsonPropertyWithDefault
    private double height = 0.2;
    @JsonPropertyWithDefault
    private double frequency = 0.05;
    @JsonPropertyWithDefault
    private double size = 1.0;
    @JsonPropertyWithDefault
    private double spread = 0.2;

    @Override
    public List<Location> getWireframe(LivingEntity entity) {
        Location location = entity.getLocation();
        ArrayList<Location> wireframe = new ArrayList<Location>();
        Vector playerDirection = entity.getEyeLocation().getDirection();
        Vector perpendicularVector1 = this.getPerpendicularVector(playerDirection);
        Vector perpendicularVector2 = this.getPerpendicularVector(playerDirection);
        for (double theta = 0.0; theta < Math.PI; theta += this.frequency) {
            double radius = this.size * Math.cos(theta);
            double horizontalOffset = radius * Math.cos(theta) + this.spread;
            double verticalOffset = radius * Math.sin(theta) + this.height + 0.5;
            Vector ear1Offset = perpendicularVector1.clone().multiply(horizontalOffset).setY(verticalOffset);
            Vector ear2Offset = perpendicularVector2.clone().multiply(-horizontalOffset).setY(verticalOffset);
            Location particleLocation = location.clone().add(ear1Offset);
            Location mirroredLocation = location.clone().add(ear2Offset);
            wireframe.add(particleLocation);
            wireframe.add(mirroredLocation);
        }
        return wireframe;
    }
}

