/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.configurationdata.particles.shapes;

import java.util.ArrayList;
import java.util.List;
import me.xemor.superheroes.configurationdata.JsonPropertyWithDefault;
import me.xemor.superheroes.configurationdata.particles.EntityShape;
import me.xemor.superheroes.configurationdata.particles.shapes.Shape;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class FairyWings
extends Shape
implements EntityShape {
    @JsonPropertyWithDefault
    private double height = 1.0;
    @JsonPropertyWithDefault
    private double frequency = 0.05;
    @JsonPropertyWithDefault
    private double size = 1.0;

    @Override
    public List<Location> getWireframe(LivingEntity entity) {
        Location location = entity.getLocation();
        ArrayList<Location> wireframe = new ArrayList<Location>();
        Vector playerDirection = entity.getEyeLocation().getDirection();
        Vector perpendicularVector1 = this.getPerpendicularVector(playerDirection);
        Vector perpendicularVector2 = this.getPerpendicularVector(playerDirection);
        for (double theta = 0.0; theta < Math.PI; theta += this.frequency) {
            double radius = Math.sin(2.0 * theta);
            double horizontalOffset = radius * Math.cos(theta) * this.size;
            double verticalOffset = radius * Math.sin(theta) * this.size + this.height;
            Vector wing1Offset = perpendicularVector1.clone().multiply(horizontalOffset).setY(verticalOffset);
            Vector wing2Offset = perpendicularVector2.clone().multiply(-horizontalOffset).setY(verticalOffset);
            Vector parallelOffset = playerDirection.clone().normalize().multiply(0.35).setY(0);
            Location particleLocation = location.clone().add(wing1Offset).subtract(parallelOffset);
            Location mirroredLocation = location.clone().add(wing2Offset).subtract(parallelOffset);
            wireframe.add(particleLocation);
            wireframe.add(mirroredLocation);
        }
        return wireframe;
    }
}

