/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.configurationdata.particles.shapes;

import com.fasterxml.jackson.annotation.JsonAlias;
import java.util.ArrayList;
import java.util.List;
import me.xemor.superheroes.configurationdata.ConfigurationData;
import me.xemor.superheroes.configurationdata.JsonPropertyWithDefault;
import me.xemor.superheroes.configurationdata.particles.EntityShape;
import me.xemor.superheroes.configurationdata.particles.shapes.Shape;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;

public class Wisp
extends Shape
implements EntityShape {
    @JsonPropertyWithDefault
    private double radius = 0.5;
    @JsonPropertyWithDefault
    private double speed = 1.0;
    @JsonPropertyWithDefault
    @JsonAlias(value={"wave_frequency"})
    private double waveFrequency = 1.0;
    @JsonPropertyWithDefault
    private double height = 2.0;

    @Override
    public List<Location> getWireframe(LivingEntity entity) {
        Location location = entity.getLocation();
        ArrayList<Location> wireframe = new ArrayList<Location>();
        double trigInput = (double)ConfigurationData.getArbitraryClock() * this.speed;
        double xCoordinate = location.getX() + this.radius * Math.cos(trigInput);
        double zCoordinate = location.getZ() + this.radius * Math.sin(trigInput);
        double cyclePosition = (Math.sin((double)ConfigurationData.getArbitraryClock() * this.waveFrequency) + 1.0) / 2.0;
        double yCoordinate = cyclePosition * this.height + location.getY();
        Location particleLocation = new Location(entity.getWorld(), xCoordinate, yCoordinate, zCoordinate);
        wireframe.add(particleLocation);
        return wireframe;
    }
}

