/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.data;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.xemor.skillslibrary2.SkillsLibrary;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.config.ConfigYaml;
import me.xemor.superheroes.configurationdata.ConfigurationData;
import me.xemor.superheroes.data.DatabaseYaml;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.data.SuperheroPlayer;
import me.xemor.superheroes.events.SuperheroLoadEvent;
import me.xemor.superheroes.events.SuperheroesReloadEvent;
import me.xemor.superheroes.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import me.xemor.superheroes.language.LanguageYaml;
import me.xemor.superheroes.skills.Skill;
import me.xemor.superheroes.skills.skilldata.spell.Spells;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ConfigHandler {
    private static final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.builder().useUnusualXRepeatedCharacterHexFormat().hexColors().build();
    private static LanguageYaml languageYAML;
    private static DatabaseYaml databaseYAML;
    private static ConfigYaml configYAML;
    private File dataFolder;
    private final Superheroes superheroes;

    public ConfigHandler(Superheroes superheroes) {
        this.superheroes = superheroes;
        superheroes.saveDefaultConfig();
        this.dataFolder = superheroes.getDataFolder();
        if (!new File(superheroes.getDataFolder(), "language.yml").exists()) {
            superheroes.saveResource("language.yml", false);
        }
        if (!new File(superheroes.getDataFolder(), "database.yml").exists()) {
            superheroes.saveResource("database.yml", false);
        }
        this.loadConfigs();
        this.handleSuperpowersFolder();
    }

    public void reloadConfig(HeroHandler heroHandler) {
        SuperheroesReloadEvent superheroesReloadEvent = new SuperheroesReloadEvent();
        Bukkit.getServer().getPluginManager().callEvent((Event)superheroesReloadEvent);
        this.loadConfigs();
        heroHandler.loadConfigItems();
        this.handleSuperpowersFolder();
        heroHandler.handlePlayerData();
        this.loadSuperheroes(heroHandler);
        heroHandler.setHeroesIntoMemory(new HashMap<UUID, SuperheroPlayer>());
        for (Player player : Bukkit.getOnlinePlayers()) {
            heroHandler.loadSuperheroPlayer(player);
        }
    }

    public void loadConfigs() {
        try {
            ObjectMapper objectMapper = this.setupObjectMapper();
            databaseYAML = (DatabaseYaml)objectMapper.readValue(new File(this.dataFolder, "database.yml"), DatabaseYaml.class);
            languageYAML = (LanguageYaml)objectMapper.readValue(new File(this.dataFolder, "language.yml"), LanguageYaml.class);
            configYAML = (ConfigYaml)objectMapper.readValue(new File(this.dataFolder, "config.yml"), ConfigYaml.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void handleSuperpowersFolder() {
        File powersFolder = this.getPowersFolder();
        if (powersFolder.mkdir()) {
            try {
                Path myPath;
                URI powers;
                FileSystem fileSystem = null;
                try {
                    powers = this.getClass().getClassLoader().getResource("powers").toURI();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    return;
                }
                if (powers.getScheme().equals("jar")) {
                    fileSystem = FileSystems.newFileSystem(powers, Collections.emptyMap());
                    myPath = fileSystem.getPath("powers", new String[0]);
                } else {
                    myPath = Paths.get(powers);
                }
                Stream<Path> walk = Files.walk(myPath, 1, new FileVisitOption[0]);
                Iterator it = walk.iterator();
                it.next();
                while (it.hasNext()) {
                    String path = ((Path)it.next()).toString();
                    if (path.charAt(0) == '/') {
                        path = path.substring(1);
                    }
                    this.superheroes.saveResource(path, false);
                }
                if (fileSystem != null) {
                    fileSystem.close();
                }
                walk.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private File getPowersFolder() {
        return new File(this.getDataFolder(), "powers");
    }

    public ObjectMapper setupObjectMapper() {
        ObjectMapper objectMapper = ConfigurationData.setupObjectMapperForConfigurationData(new ObjectMapper((JsonFactory)new YAMLFactory()));
        if (this.superheroes.hasSkillsLibrary()) {
            objectMapper = SkillsLibrary.getInstance().setupObjectMapper(objectMapper);
        }
        objectMapper.registerSubtypes(Skill.getNamedTypes());
        objectMapper.registerSubtypes(Spells.getNamedTypes());
        return objectMapper;
    }

    public void loadSuperheroes(HeroHandler heroHandler) {
        ObjectMapper objectMapper = this.setupObjectMapper();
        Map<String, Superhero> nameToSuperhero = ((Stream)Arrays.stream(this.getPowersFolder().listFiles()).parallel()).filter(file -> file.getName().endsWith(".yml") || file.getName().endsWith(".yaml")).map(file -> {
            Superhero superhero;
            FileInputStream is = new FileInputStream((File)file);
            try {
                superhero = (Superhero)objectMapper.readValue((InputStream)is, Superhero.class);
            }
            catch (Throwable t$) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable x2) {
                        t$.addSuppressed(x2);
                    }
                    throw t$;
                }
                catch (IOException e) {
                    Superheroes.getInstance().getLogger().severe("While parsing file: %s\n%s".formatted(file.getName(), e));
                    return null;
                }
            }
            ((InputStream)is).close();
            return superhero;
        }).filter(Objects::nonNull).toList().stream().map(hero -> {
            SuperheroLoadEvent superheroLoadEvent = new SuperheroLoadEvent((Superhero)hero);
            Bukkit.getServer().getPluginManager().callEvent((Event)superheroLoadEvent);
            if (superheroLoadEvent.isCancelled()) {
                return null;
            }
            return hero;
        }).filter(Objects::nonNull).filter(it -> it.getName() != null).collect(Collectors.toMap(hero -> hero.getName().toLowerCase(), hero -> hero));
        heroHandler.registerHeroes(nameToSuperhero);
    }

    private File getDataFolder() {
        return Superheroes.getInstance().getDataFolder();
    }

    public Superhero getDefaultHero() {
        return configYAML.defaultHero();
    }

    public static LanguageYaml getLanguageYAML() {
        return languageYAML;
    }

    public static DatabaseYaml getDatabaseYAML() {
        return databaseYAML;
    }

    public static ConfigYaml getConfigYAML() {
        return configYAML;
    }
}

