/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.data.ConfigHandler;
import me.xemor.superheroes.data.HeroIOHandler;
import me.xemor.superheroes.data.SuperheroPlayer;
import me.xemor.superheroes.events.PlayerAsyncCheckSuperheroEvent;
import me.xemor.superheroes.events.PlayerChangedSuperheroEvent;
import me.xemor.superheroes.events.SuperheroPlayerJoinEvent;
import me.xemor.superheroes.kyori.adventure.audience.Audience;
import me.xemor.superheroes.kyori.adventure.text.Component;
import me.xemor.superheroes.kyori.adventure.text.minimessage.MiniMessage;
import me.xemor.superheroes.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import me.xemor.superheroes.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;
import me.xemor.superheroes.reroll.RerollGroup;
import me.xemor.userinterface.ChestInterface;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class HeroHandler {
    private final ConcurrentHashMap<UUID, SuperheroPlayer> uuidToData = new ConcurrentHashMap();
    private final Superheroes superheroes;
    private final ConfigHandler configHandler;
    private Superhero noPower;
    private HeroIOHandler heroIOHandler;
    private List<String> disabledWorlds;
    private ConcurrentHashMap<String, Superhero> nameToSuperhero = new ConcurrentHashMap();

    public HeroHandler(Superheroes superheroes, ConfigHandler configHandler) {
        this.configHandler = configHandler;
        this.superheroes = superheroes;
        this.heroIOHandler = new HeroIOHandler();
        this.loadConfigItems();
    }

    public void loadConfigItems() {
        this.noPower = this.configHandler.getDefaultHero();
        this.disabledWorlds = ConfigHandler.getConfigYAML().disabledWorlds();
    }

    public void registerHeroes(Map<String, Superhero> nameToSuperhero) {
        this.nameToSuperhero.clear();
        this.nameToSuperhero.putAll(nameToSuperhero);
        this.nameToSuperhero.put(this.noPower.getName().toLowerCase(), this.noPower);
    }

    public void setHeroesIntoMemory(Map<UUID, SuperheroPlayer> playerHeroes) {
        this.uuidToData.clear();
        this.uuidToData.putAll(playerHeroes);
    }

    public void handlePlayerData() {
        this.heroIOHandler.handlePlayerData();
    }

    public SuperheroPlayer getSuperheroPlayer(Player player) {
        return this.uuidToData.get(player.getUniqueId());
    }

    public SuperheroPlayer getSuperheroPlayer(UUID uniqueId) {
        return this.uuidToData.get(uniqueId);
    }

    @NotNull
    public Superhero getSuperhero(Player player) {
        if (this.disabledWorlds.contains(player.getWorld().getName())) {
            return this.noPower;
        }
        SuperheroPlayer heroPlayer = this.uuidToData.get(player.getUniqueId());
        if (heroPlayer == null) {
            return this.noPower;
        }
        Superhero hero = heroPlayer.getSuperhero();
        if (player.getGameMode() == GameMode.SPECTATOR && !hero.hasSkill("PHASE")) {
            return this.noPower;
        }
        PlayerAsyncCheckSuperheroEvent event = new PlayerAsyncCheckSuperheroEvent(hero, player);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return event.getSuperhero();
    }

    @NotNull
    public Superhero getSuperhero(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        return this.getSuperhero(player);
    }

    public void setHeroInMemory(Player player, Superhero hero) {
        this.setHeroInMemory(player, hero, true);
    }

    public void setHeroInMemory(Player player, Superhero hero, boolean show) {
        this.setHeroInMemory(player, hero, show, PlayerChangedSuperheroEvent.Cause.OTHER);
    }

    public void setHeroInMemory(Player player, Superhero hero, boolean show, PlayerChangedSuperheroEvent.Cause cause) {
        this.setHeroInMemory(player, hero, show, cause, false);
    }

    private void setHeroInMemory(Player player, Superhero hero, boolean show, PlayerChangedSuperheroEvent.Cause cause, boolean wasWrittenToDisk) {
        SuperheroPlayer superheroPlayer = this.uuidToData.get(player.getUniqueId());
        if (superheroPlayer == null) {
            superheroPlayer = new SuperheroPlayer(player.getUniqueId(), hero, 0L);
            this.uuidToData.put(player.getUniqueId(), superheroPlayer);
        }
        Superhero currentHero = superheroPlayer.getSuperhero();
        PlayerChangedSuperheroEvent playerChangedHero = new PlayerChangedSuperheroEvent(player, hero, currentHero, cause, wasWrittenToDisk);
        Bukkit.getServer().getPluginManager().callEvent((Event)playerChangedHero);
        if (!playerChangedHero.isCancelled()) {
            superheroPlayer.setSuperhero(playerChangedHero.getNewHero());
            if (show) {
                this.showHero(player, playerChangedHero.getNewHero());
            }
        }
    }

    public void setHero(Player player, Superhero hero) {
        this.setHero(player, hero, true);
    }

    public void setHero(Player player, Superhero hero, boolean show) {
        this.setHero(player, hero, show, PlayerChangedSuperheroEvent.Cause.OTHER);
    }

    public void setHero(Player player, Superhero hero, boolean show, PlayerChangedSuperheroEvent.Cause cause) {
        this.setHeroInMemory(player, hero, show, cause, true);
        this.heroIOHandler.saveSuperheroPlayerAsync(this.getSuperheroPlayer(player));
    }

    public void openHeroGUI(Player player) {
        List<Superhero> allowedSuperheroes = this.nameToSuperhero.values().stream().filter(hero -> !Superheroes.getInstance().getRerollHandler().getRerollConfig().getGlobalRerollSettings().doesEachHeroRequirePermissions() || player.hasPermission(hero.getPermission())).toList();
        if (allowedSuperheroes.isEmpty()) {
            return;
        }
        int numberOfRows = (allowedSuperheroes.size() - 1) / 9 + 1;
        if (numberOfRows > 6) {
            Superheroes.getInstance().getLogger().severe("The hero GUI does not support more than 54 heroes.");
            return;
        }
        ChestInterface<boolean[]> chestInterface = new ChestInterface<boolean[]>(ConfigHandler.getLanguageYAML().guiLanguageSettings().getName(), numberOfRows, new boolean[]{false});
        for (Superhero superhero : allowedSuperheroes) {
            if (superhero.getIcon() == null) continue;
            chestInterface.getInventory().addItem(new ItemStack[]{superhero.getIcon()});
            chestInterface.getInteractions().addSimpleInteraction(superhero.getIcon(), p -> {
                if (this.getSuperheroPlayer(player).handleCooldown(player, Superheroes.getBukkitAudiences().player(player))) {
                    this.setHero((Player)p, superhero);
                }
                ((boolean[])chestInterface.getInteractions().getData())[0] = true;
                player.closeInventory();
            });
            if (ConfigHandler.getConfigYAML().gui().closeable()) continue;
            chestInterface.getInteractions().addCloseInteraction(p -> Superheroes.getScheduling().entitySpecificScheduler((Entity)player).runDelayed(() -> {
                if (!((boolean[])chestInterface.getInteractions().getData())[0]) {
                    this.openHeroGUI(player);
                }
            }, () -> {}, 1L));
        }
        player.openInventory(chestInterface.getInventory());
    }

    public void loadSuperheroPlayer(@NotNull Player player) {
        CompletableFuture<SuperheroPlayer> future = this.heroIOHandler.loadSuperHeroPlayerAsync(player.getUniqueId());
        future.thenAccept(superheroPlayer -> Superheroes.getScheduling().entitySpecificScheduler((Entity)player).run(() -> {
            Superhero superhero;
            if (superheroPlayer != null) {
                this.uuidToData.put(player.getUniqueId(), (SuperheroPlayer)superheroPlayer);
                superhero = superheroPlayer.getSuperhero();
            } else {
                RerollGroup defaultGroup = Superheroes.getInstance().getRerollHandler().getWeightedHeroes("default");
                if (defaultGroup == null) {
                    throw new IllegalStateException("Default Reroll Group not initialized for some reason!");
                }
                Superhero superhero2 = superhero = ConfigHandler.getConfigYAML().powerOnStart().enabled() ? defaultGroup.chooseHero(player) : this.noPower;
                if (ConfigHandler.getConfigYAML().gui().startsOpen()) {
                    this.openHeroGUI(player);
                }
                this.setHero(player, superhero, ConfigHandler.getConfigYAML().powerOnStart().firstJoinTitle());
            }
            SuperheroPlayerJoinEvent playerJoinEvent = new SuperheroPlayerJoinEvent(superhero, player);
            Bukkit.getPluginManager().callEvent((Event)playerJoinEvent);
        }, () -> {}));
    }

    public void unloadSuperheroPlayer(@NotNull Player player) {
        this.uuidToData.remove(player.getUniqueId());
    }

    @Deprecated
    public Superhero getRandomHero(Player player) {
        ArrayList<Superhero> superheroes = new ArrayList<Superhero>(this.nameToSuperhero.values());
        Collections.shuffle(superheroes);
        Superhero newHero = this.noPower;
        for (Superhero superhero : superheroes) {
            if (Superheroes.getInstance().getRerollHandler().getRerollConfig().getGlobalRerollSettings().doesEachHeroRequirePermissions() && !player.hasPermission(superhero.getPermission()) || this.noPower.equals(superhero)) continue;
            newHero = superhero;
            break;
        }
        return newHero;
    }

    public void showHero(Player player, Superhero hero) {
        Object colouredName = MiniMessage.miniMessage().deserialize(hero.getColouredName());
        Object description = MiniMessage.miniMessage().deserialize(hero.getDescription());
        Audience playerAudience = Superheroes.getBukkitAudiences().player(player);
        String colouredNameSpigot = LegacyComponentSerializer.builder().useUnusualXRepeatedCharacterHexFormat().hexColors().build().serialize((Component)colouredName);
        String descriptionSpigot = LegacyComponentSerializer.builder().useUnusualXRepeatedCharacterHexFormat().hexColors().build().serialize((Component)description);
        player.sendTitle(colouredNameSpigot, descriptionSpigot, 10, 100, 10);
        if (hero.getHeroGainedSound() != null) {
            player.playSound(player.getLocation(), hero.getHeroGainedSound().sound(), hero.getHeroGainedSound().volume(), hero.getHeroGainedSound().pitch());
        } else {
            player.playSound(player.getLocation(), Sound.ITEM_TOTEM_USE, 0.5f, 1.0f);
        }
        Component heroGainedMessage = MiniMessage.miniMessage().deserialize(ConfigHandler.getLanguageYAML().chatLanguageSettings().getGainedHero(), Placeholder.component("hero", colouredName), Placeholder.unparsed("player", player.getName()));
        playerAudience.sendMessage(heroGainedMessage);
    }

    @Nullable
    public Superhero getSuperhero(String name) {
        if (name == null) {
            return null;
        }
        return this.nameToSuperhero.get(name.toLowerCase());
    }

    public Superheroes getPlugin() {
        return this.superheroes;
    }

    public Map<String, Superhero> getNameToSuperhero() {
        return this.nameToSuperhero;
    }

    public Superhero getNoPower() {
        return this.noPower;
    }

    public HeroIOHandler getHeroIOHandler() {
        return this.heroIOHandler;
    }
}

