/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.data;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.data.ConfigHandler;
import me.xemor.superheroes.data.SuperheroPlayer;
import me.xemor.superheroes.data.storage.MySQLStorage;
import me.xemor.superheroes.data.storage.Storage;
import me.xemor.superheroes.data.storage.YAMLStorage;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;
import org.bukkit.Bukkit;

public class HeroIOHandler {
    final ExecutorService threads;
    @Nullable
    private Storage storage;
    private static final Object POISON = new Object();
    private final BlockingQueue<Object> loadingPlayerQueue = new LinkedBlockingQueue<Object>();
    private final BlockingQueue<Object> savingPlayerQueue = new LinkedBlockingQueue<Object>();
    private final ConfigHandler configHandler = Superheroes.getInstance().getConfigHandler();

    public HeroIOHandler() {
        this.threads = Executors.newFixedThreadPool(2);
        this.threads.submit(this::loadPlayersInQueue);
        this.threads.submit(this::savePlayersInQueue);
    }

    public void loadPlayersInQueue() {
        while (true) {
            try {
                while (true) {
                    if (this.storage == null) {
                        Superheroes.getInstance().getLogger().log(Level.FINE, "Waiting 1000ms for server to finish loading.");
                        Thread.sleep(1000L);
                        continue;
                    }
                    Object object = this.loadingPlayerQueue.take();
                    if (object == POISON) {
                        return;
                    }
                    LoadingPlayer player = (LoadingPlayer)object;
                    SuperheroPlayer superheroPlayer = this.storage.loadSuperheroPlayer(player.getUUID());
                    player.getFuture().complete(superheroPlayer);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void savePlayersInQueue() {
        while (true) {
            try {
                while (true) {
                    if (this.storage == null) {
                        Superheroes.getInstance().getLogger().fine("Storage is null... waiting 1s for server to finish loading.");
                        Thread.sleep(1000L);
                        continue;
                    }
                    Object object = this.savingPlayerQueue.take();
                    if (object == POISON) {
                        return;
                    }
                    SavingPlayer player = (SavingPlayer)object;
                    this.storage.saveSuperheroPlayer(player.getSuperheroPlayer());
                    player.getFuture().complete(new Object());
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public CompletableFuture<SuperheroPlayer> loadSuperHeroPlayerAsync(UUID uuid) {
        LoadingPlayer loadingPlayer = new LoadingPlayer(uuid);
        try {
            this.loadingPlayerQueue.put(loadingPlayer);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return loadingPlayer.getFuture();
    }

    public void saveSuperheroPlayerAsync(SuperheroPlayer superheroPlayer) {
        SavingPlayer savingPlayer = new SavingPlayer(superheroPlayer);
        try {
            this.savingPlayerQueue.put(savingPlayer);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void handlePlayerData() {
        String databaseType = ConfigHandler.getDatabaseYAML().database().getType();
        if (databaseType.equalsIgnoreCase("YAML")) {
            this.storage = new YAMLStorage();
        } else if (databaseType.equalsIgnoreCase("MySQL")) {
            this.storage = new MySQLStorage();
        } else {
            Bukkit.getLogger().severe("Invalid database type specified!");
        }
    }

    public CompletableFuture<Void> importFiles() {
        YAMLStorage yamlStorage = new YAMLStorage();
        List<SuperheroPlayer> superheroPlayers = yamlStorage.exportSuperheroPlayers();
        return this.storage.importSuperheroPlayers(superheroPlayers);
    }

    public void exportFiles() {
        List<SuperheroPlayer> superheroPlayers = this.storage.exportSuperheroPlayers();
        YAMLStorage yamlStorage = new YAMLStorage();
        yamlStorage.importSuperheroPlayers(superheroPlayers);
    }

    public void shutdown() {
        this.loadingPlayerQueue.add(POISON);
        this.savingPlayerQueue.add(POISON);
        this.threads.shutdown();
        try {
            this.threads.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static class LoadingPlayer {
        private final UUID uuid;
        private final CompletableFuture<SuperheroPlayer> future = new CompletableFuture();

        public LoadingPlayer(UUID uuid) {
            this.uuid = uuid;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public CompletableFuture<SuperheroPlayer> getFuture() {
            return this.future;
        }
    }

    static class SavingPlayer {
        private final SuperheroPlayer superheroPlayer;
        private final CompletableFuture<Object> future = new CompletableFuture();

        public SavingPlayer(SuperheroPlayer superheroPlayer) {
            this.superheroPlayer = superheroPlayer;
        }

        public SuperheroPlayer getSuperheroPlayer() {
            return this.superheroPlayer;
        }

        public CompletableFuture<Object> getFuture() {
            return this.future;
        }
    }
}

