/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.data;

import java.util.UUID;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.data.ConfigHandler;
import me.xemor.superheroes.kyori.adventure.audience.Audience;
import me.xemor.superheroes.kyori.adventure.text.Component;
import me.xemor.superheroes.kyori.adventure.text.minimessage.MiniMessage;
import me.xemor.superheroes.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import org.bukkit.entity.Player;

public class SuperheroPlayer {
    private final UUID uuid;
    private Superhero superhero;
    private long heroCommandTimestamp;

    public SuperheroPlayer(@NotNull UUID uuid, @NotNull Superhero superhero, long heroCommandTimestamp) {
        this.uuid = uuid;
        this.superhero = superhero;
        this.heroCommandTimestamp = heroCommandTimestamp;
    }

    @NotNull
    public UUID getUUID() {
        return this.uuid;
    }

    @NotNull
    public Superhero getSuperhero() {
        return this.superhero;
    }

    public long getHeroCommandTimestamp() {
        return this.heroCommandTimestamp;
    }

    public void setSuperhero(@NotNull Superhero superhero) {
        this.superhero = superhero;
    }

    public void setHeroCommandTimestamp(long heroCommandTimestamp) {
        this.heroCommandTimestamp = heroCommandTimestamp;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SuperheroPlayer) {
            SuperheroPlayer superheroPlayer = (SuperheroPlayer)other;
            return this.uuid == superheroPlayer.uuid && this.superhero.equals(superheroPlayer.getSuperhero()) && this.heroCommandTimestamp == superheroPlayer.getHeroCommandTimestamp();
        }
        return false;
    }

    public boolean isCooldownOver() {
        return this.getCooldownLeft() <= 0L;
    }

    public long getCooldownLeft() {
        long cooldown = (long)ConfigHandler.getConfigYAML().heroCommand().cooldown() * 1000L;
        return cooldown - (System.currentTimeMillis() - this.getHeroCommandTimestamp());
    }

    public boolean handleCooldown(Player player, Audience audience) {
        long seconds = this.getCooldownLeft() / 1000L;
        if (!player.hasPermission("superheroes.hero.select.bypasscooldown") && !this.isCooldownOver()) {
            Component message = MiniMessage.miniMessage().deserialize(ConfigHandler.getLanguageYAML().chatLanguageSettings().getHeroCommandCooldown(), Placeholder.unparsed("player", player.getName()), Placeholder.unparsed("currentcooldown", String.valueOf(Math.round(seconds))), Placeholder.unparsed("cooldown", String.valueOf(ConfigHandler.getConfigYAML().heroCommand().cooldown())));
            audience.sendMessage(message);
            return false;
        }
        this.setHeroCommandTimestamp(System.currentTimeMillis());
        return true;
    }
}

