/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.lushplugins.unifiedprotection.bukkit;

import java.util.concurrent.Callable;
import java.util.logging.Level;
import me.xemor.superheroes.lushplugins.unifiedprotection.UnifiedProtection;
import me.xemor.superheroes.lushplugins.unifiedprotection.bukkit.BukkitConverter;
import me.xemor.superheroes.lushplugins.unifiedprotection.bukkit.hook.GriefPreventionHook;
import me.xemor.superheroes.lushplugins.unifiedprotection.bukkit.hook.PvPToggleHook;
import me.xemor.superheroes.lushplugins.unifiedprotection.bukkit.hook.WorldGuardHook;
import me.xemor.superheroes.lushplugins.unifiedprotection.hook.AbstractHook;
import me.xemor.superheroes.lushplugins.unifiedprotection.hook.HuskClaimsHook;
import me.xemor.superheroes.lushplugins.unifiedprotection.hook.HuskTownsHook;
import me.xemor.superheroes.lushplugins.unifiedprotection.player.OnlinePlayer;
import me.xemor.superheroes.org.jetbrains.annotations.ApiStatus;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.lushplugins.libraries.cloplib.operation.OperationPosition;
import org.lushplugins.libraries.cloplib.operation.OperationType;

public class BukkitUnifiedProtection
extends UnifiedProtection {
    public BukkitUnifiedProtection() {
        this.addPluginHook("GriefPrevention", () -> new GriefPreventionHook());
        this.addPluginHook("HuskClaims", () -> new HuskClaimsHook());
        this.addPluginHook("HuskTowns", () -> new HuskTownsHook());
        this.addPluginHook("PvPToggle", () -> new PvPToggleHook());
        this.addPluginHook("WorldGuard", () -> new WorldGuardHook());
    }

    public boolean isOperationAllowed(OperationType operationType, Location location) {
        return this.isOperationAllowed(operationType, location, null);
    }

    public boolean isOperationAllowed(OperationType operationType, Location location, @Nullable Player player) {
        OperationPosition position = BukkitConverter.convert(location);
        OnlinePlayer onlinePlayer = BukkitConverter.convert(player);
        return this.isOperationAllowed(operationType, position, onlinePlayer);
    }

    public boolean hasRegionWithin(Location loc1, Location loc2) {
        OperationPosition pos1 = BukkitConverter.convert(loc1);
        OperationPosition pos2 = BukkitConverter.convert(loc2);
        return this.hasRegionWithin(pos1, pos2);
    }

    @ApiStatus.Experimental
    public boolean ownsAllRegionsWithin(Location loc1, Location loc2, Player player) {
        OperationPosition pos1 = BukkitConverter.convert(loc1);
        OperationPosition pos2 = BukkitConverter.convert(loc2);
        OnlinePlayer onlinePlayer = BukkitConverter.convert(player);
        return this.ownsAllRegionsWithin(pos1, pos2, onlinePlayer);
    }

    public void addPluginHook(String pluginName, Callable<AbstractHook> hook) {
        Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
        if (plugin != null && plugin.isEnabled()) {
            try {
                this.addHook(hook.call());
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.WARNING, "[UnifiedProtection] Error whilst loading hook: ", e);
            }
        }
    }
}

