/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.me.sepdron.headcreator;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;

public final class HeadCreator {
    private static Constructor<? extends PlayerProfile> playerProfileConstructor;

    public static ItemStack createFromBase64(String b64) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        HeadCreator.setBase64Skin(skull, b64);
        return skull;
    }

    public static void setBase64Skin(SkullMeta meta, String b64) {
        meta.setOwnerProfile(HeadCreator.createProfile(b64));
    }

    public static void setBase64Skin(ItemStack item, String b64) {
        ItemMeta meta = item.getItemMeta();
        if (!(meta instanceof SkullMeta)) {
            throw new IllegalArgumentException("Item does not have a skull meta");
        }
        SkullMeta skullMeta = (SkullMeta)meta;
        HeadCreator.setBase64Skin(skullMeta, b64);
        item.setItemMeta((ItemMeta)skullMeta);
    }

    private static void createProfileConstructor(String b64) {
        Server server = Bukkit.getServer();
        UUID id = HeadCreator.createUUID(b64);
        PlayerProfile playerProfile = server.createPlayerProfile(id);
        try {
            playerProfileConstructor = playerProfile.getClass().getDeclaredConstructor(GameProfile.class);
            playerProfileConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static PlayerProfile createProfile(String b64) {
        if (playerProfileConstructor == null) {
            HeadCreator.createProfileConstructor(b64);
        }
        GameProfile gameProfile = HeadCreator.createGameProfile(b64);
        try {
            return playerProfileConstructor.newInstance(gameProfile);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static GameProfile createGameProfile(String b64) {
        UUID id = HeadCreator.createUUID(b64);
        Property texturesProperty = new Property("textures", b64);
        PropertyMap properties = new PropertyMap((Multimap)ImmutableMultimap.of((Object)"textures", (Object)texturesProperty));
        return new GameProfile(id, "Player", properties);
    }

    private static UUID createUUID(String b64) {
        return new UUID(b64.substring(b64.length() - 20).hashCode(), b64.substring(b64.length() - 10).hashCode());
    }
}

