/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.morepaperlib.scheduling;

import java.time.Duration;
import java.util.function.Consumer;
import me.xemor.superheroes.morepaperlib.MorePaperLib;
import me.xemor.superheroes.morepaperlib.scheduling.AsynchronousScheduler;
import me.xemor.superheroes.morepaperlib.scheduling.BukkitTaskConsumerToRunnable;
import me.xemor.superheroes.morepaperlib.scheduling.PaperTask;
import me.xemor.superheroes.morepaperlib.scheduling.ScheduledTask;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

final class BukkitSchedulerAsAsynchronousScheduler
implements AsynchronousScheduler {
    private final BukkitScheduler scheduler;
    private final Plugin plugin;
    private final boolean hasMethodRunTask;
    private final boolean hasMethodRunTaskLater;
    private final boolean hasMethodRunTaskTimer;

    BukkitSchedulerAsAsynchronousScheduler(MorePaperLib morePaperLib) {
        Plugin plugin = morePaperLib.getPlugin();
        this.scheduler = plugin.getServer().getScheduler();
        this.plugin = plugin;
        this.hasMethodRunTask = morePaperLib.methodExists(BukkitScheduler.class, "runTaskAsynchronously", Plugin.class, Consumer.class);
        this.hasMethodRunTaskLater = morePaperLib.methodExists(BukkitScheduler.class, "runTaskLaterAsynchronously", Plugin.class, Consumer.class, Long.TYPE);
        this.hasMethodRunTaskTimer = morePaperLib.methodExists(BukkitScheduler.class, "runTaskTimerAsynchronously", Plugin.class, Consumer.class, Long.TYPE, Long.TYPE);
    }

    void cancelTasks() {
        this.scheduler.cancelTasks(this.plugin);
    }

    private static long toTicks(Duration duration) {
        return duration.toMillis() / 50L;
    }

    @Override
    public void execute(@NotNull Runnable command) {
        this.scheduler.runTaskAsynchronously(this.plugin, command);
    }

    @Override
    public ScheduledTask run(Runnable command) {
        return new PaperTask(this.scheduler.runTaskAsynchronously(this.plugin, command));
    }

    @Override
    public void run(Consumer<ScheduledTask> command) {
        if (this.hasMethodRunTask) {
            this.scheduler.runTaskAsynchronously(this.plugin, bukkitTask -> command.accept(new PaperTask((BukkitTask)bukkitTask)));
            return;
        }
        BukkitTaskConsumerToRunnable.setup(command, runnable -> this.scheduler.runTaskAsynchronously(this.plugin, runnable));
    }

    @Override
    public ScheduledTask runDelayed(Runnable command, Duration delay) {
        return new PaperTask(this.scheduler.runTaskLaterAsynchronously(this.plugin, command, BukkitSchedulerAsAsynchronousScheduler.toTicks(delay)));
    }

    @Override
    public void runDelayed(Consumer<ScheduledTask> command, Duration delay) {
        long delayInTicks = BukkitSchedulerAsAsynchronousScheduler.toTicks(delay);
        if (this.hasMethodRunTaskLater) {
            this.scheduler.runTaskLaterAsynchronously(this.plugin, bukkitTask -> command.accept(new PaperTask((BukkitTask)bukkitTask)), delayInTicks);
            return;
        }
        BukkitTaskConsumerToRunnable.setup(command, runnable -> this.scheduler.runTaskLaterAsynchronously(this.plugin, runnable, delayInTicks));
    }

    @Override
    public ScheduledTask runAtFixedRate(Runnable command, Duration initialDelay, Duration period) {
        return new PaperTask(this.scheduler.runTaskTimerAsynchronously(this.plugin, command, BukkitSchedulerAsAsynchronousScheduler.toTicks(initialDelay), BukkitSchedulerAsAsynchronousScheduler.toTicks(period)));
    }

    @Override
    public void runAtFixedRate(Consumer<ScheduledTask> command, Duration initialDelay, Duration period) {
        long initialDelayInTicks = BukkitSchedulerAsAsynchronousScheduler.toTicks(initialDelay);
        long periodInTicks = BukkitSchedulerAsAsynchronousScheduler.toTicks(period);
        if (this.hasMethodRunTaskTimer) {
            this.scheduler.runTaskTimerAsynchronously(this.plugin, bukkitTask -> command.accept(new PaperTask((BukkitTask)bukkitTask)), initialDelayInTicks, periodInTicks);
            return;
        }
        BukkitTaskConsumerToRunnable.setup(command, runnable -> this.scheduler.runTaskTimerAsynchronously(this.plugin, runnable, initialDelayInTicks, periodInTicks));
    }
}

