/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.reroll;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.configurationdata.JsonPropertyWithDefault;
import me.xemor.superheroes.configurationdata.comparison.ItemComparisonData;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RerollGroup {
    @JsonIgnore
    private int weightSum = -1;
    @JsonPropertyWithDefault
    @JsonAlias(value={"heroes"})
    private List<WeightedHero> weightedHeroes = new ArrayList<WeightedHero>();
    @JsonPropertyWithDefault
    @JsonAlias(value={"item"})
    private ItemComparisonData itemComparator = null;

    private void handleEmptyWeightedHeroes() {
        if (this.weightSum == 0) {
            this.weightedHeroes = Superheroes.getInstance().getHeroHandler().getNameToSuperhero().values().stream().map(h -> new WeightedHero((Superhero)h, 1)).toList();
            this.weightSum = this.weightedHeroes.size();
        }
    }

    @Nullable
    public Superhero chooseHero(@NotNull Player player) {
        if (this.weightSum == -1) {
            this.weightSum = this.weightedHeroes.stream().map(it -> it.weight).reduce(Integer::sum).orElse(0);
        }
        if (this.weightedHeroes.isEmpty()) {
            this.handleEmptyWeightedHeroes();
        }
        boolean possible = false;
        for (WeightedHero wHero : this.weightedHeroes) {
            if (!this.canUseHero(player, wHero.hero)) continue;
            possible = true;
            break;
        }
        if (!possible) {
            return null;
        }
        Superhero chosen = null;
        block1: while (!this.canUseHero(player, chosen)) {
            double currentWeight = 0.0;
            double rng = ThreadLocalRandom.current().nextDouble();
            for (WeightedHero wHero : this.weightedHeroes) {
                if (!(rng <= (currentWeight += (double)wHero.weight / (double)this.weightSum))) continue;
                chosen = wHero.hero;
                continue block1;
            }
        }
        return chosen;
    }

    private boolean canUseHero(@NotNull Player player, @Nullable Superhero hero) {
        if (hero == null) {
            return false;
        }
        return !Superheroes.getInstance().getRerollHandler().getRerollConfig().getGlobalRerollSettings().doesEachHeroRequirePermissions() || player.hasPermission(hero.getPermission());
    }

    public boolean matchesItem(ItemStack item) {
        if (this.itemComparator == null) {
            return false;
        }
        return this.itemComparator.matches(item);
    }

    private record WeightedHero(Superhero hero, int weight) {
        @JsonCreator
        public WeightedHero(@JsonProperty(value="hero") String hero, @JsonProperty(value="weight") int weight) {
            this(Superheroes.getInstance().getHeroHandler().getSuperhero(hero), weight);
        }
    }
}

