/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.reroll;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import me.xemor.superheroes.CooldownHandler;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.configurationdata.ConfigurationData;
import me.xemor.superheroes.events.SuperheroesReloadEvent;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;
import me.xemor.superheroes.reroll.RerollConfig;
import me.xemor.superheroes.reroll.RerollGroup;
import net.md_5.bungee.api.ChatMessageType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class RerollHandler
implements Listener {
    @JsonIgnore
    private final CooldownHandler cooldownHandler = new CooldownHandler("", ChatMessageType.ACTION_BAR);
    private RerollConfig rerollConfig;

    public RerollHandler() {
        this.loadData();
    }

    public void loadData() {
        File rerollConfig = new File(Superheroes.getInstance().getDataFolder(), "reroll.yml");
        if (!rerollConfig.exists()) {
            Superheroes.getInstance().saveResource("reroll.yml", false);
        }
        try {
            this.rerollConfig = (RerollConfig)ConfigurationData.setupObjectMapperForConfigurationData(new ObjectMapper((JsonFactory)new YAMLFactory())).readValue(rerollConfig, RerollConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent e) {
        Player player = e.getPlayer();
        ItemStack item = e.getPlayer().getInventory().getItemInMainHand();
        if ((e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK) && this.rerollConfig.getGlobalRerollSettings().isItemEnabled()) {
            for (RerollGroup group : this.rerollConfig.rerollGroups().values()) {
                if (!group.matchesItem(item) || !this.cooldownHandler.isCooldownOver(e.getPlayer().getUniqueId())) continue;
                item.setAmount(item.getAmount() - 1);
                Superhero newHero = group.chooseHero(player);
                Superheroes.getInstance().getHeroHandler().setHero(player, newHero);
                this.cooldownHandler.startCooldown(this.rerollConfig.getGlobalRerollSettings().getItemCooldown(), player.getUniqueId());
            }
        }
    }

    @EventHandler
    public void onReload(SuperheroesReloadEvent e) {
        this.loadData();
    }

    @Nullable
    public RerollGroup getWeightedHeroes(@NotNull String groupName) {
        return this.rerollConfig.rerollGroups().get(groupName.toLowerCase());
    }

    public RerollConfig getRerollConfig() {
        return this.rerollConfig;
    }

    public Collection<Map.Entry<String, RerollGroup>> getIterator() {
        return this.rerollConfig.rerollGroups().entrySet();
    }
}

