/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.Collection;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.events.PlayerChangedSuperheroEvent;
import me.xemor.superheroes.events.SuperheroPlayerJoinEvent;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.AuraData;
import me.xemor.superheroes.skills.skilldata.SkillData;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;

public class AuraSkill
extends SkillImplementation {
    public AuraSkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onJoin(SuperheroPlayerJoinEvent e) {
        this.runnable(e.getPlayer());
    }

    @EventHandler
    public void onPowerGain(PlayerChangedSuperheroEvent e) {
        this.runnable(e.getPlayer());
    }

    public void runnable(Player player) {
        Superheroes.getScheduling().entitySpecificScheduler((Entity)player).runAtFixedRate(task -> {
            if (player == null) {
                task.cancel();
                return;
            }
            if (!player.isOnline()) {
                task.cancel();
                return;
            }
            Collection<SkillData> skillDatas = Superheroes.getInstance().getHeroHandler().getSuperhero(player).getSkillData("AURA");
            if (skillDatas.isEmpty()) {
                task.cancel();
                return;
            }
            for (SkillData skillData : skillDatas) {
                AuraData auraData = (AuraData)skillData;
                World world = player.getWorld();
                Location location = player.getLocation();
                double diameter = auraData.getDiameter();
                Collection nearbyLivingEntities = world.getNearbyEntities(location, diameter, diameter, diameter, entity -> !player.equals(entity) && entity instanceof LivingEntity);
                for (Entity entity2 : nearbyLivingEntities) {
                    skillData.ifConditionsTrue(() -> {
                        LivingEntity livingEntity = (LivingEntity)entity2;
                        Superheroes.getFoliaHacks().runASAP((Entity)livingEntity, () -> auraData.getPotionEffect().ifPresent(arg_0 -> ((LivingEntity)livingEntity).addPotionEffect(arg_0)));
                    }, player, entity2);
                }
            }
        }, () -> {}, 10L, 10L);
    }
}

