/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.Collection;
import java.util.List;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.events.PlayerChangedSuperheroEvent;
import me.xemor.superheroes.events.SuperheroPlayerJoinEvent;
import me.xemor.superheroes.events.SuperheroesReloadEvent;
import me.xemor.superheroes.foliahacks.PlayerPostRespawnFoliaEvent;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.CraftingData;
import me.xemor.superheroes.skills.skilldata.SkillData;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public class CraftingSkill
extends SkillImplementation {
    public CraftingSkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onPowerGain(PlayerChangedSuperheroEvent e) {
        this.discoverRecipes(e.getPlayer(), e.getNewHero());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJoin(SuperheroPlayerJoinEvent e) {
        Superheroes.getFoliaHacks().getScheduling().entitySpecificScheduler((Entity)e.getPlayer()).runDelayed(() -> {
            Superhero superhero = this.heroHandler.getSuperhero(e.getPlayer());
            this.discoverRecipes(e.getPlayer(), superhero);
        }, () -> {}, 10L);
    }

    @EventHandler
    public void onPostRespawn(PlayerPostRespawnFoliaEvent e) {
        this.discoverRecipes(e.getPlayer(), this.heroHandler.getSuperhero(e.getPlayer()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onServerLoad(ServerLoadEvent e) {
        this.discoverForAllLate();
    }

    public void discoverRecipes(Player player, Superhero hero) {
        Collection<SkillData> skills = hero.getSkillData("CRAFTING");
        for (SkillData skill : skills) {
            CraftingData craftingData = (CraftingData)skill;
            NamespacedKey namespacedKey = ((Keyed)craftingData.getRecipe()).getKey();
            player.discoverRecipe(namespacedKey);
        }
    }

    @EventHandler
    public void onPowerLost(PlayerChangedSuperheroEvent e) {
        Superhero superhero = e.getOldHero();
        Collection<SkillData> skills = superhero.getSkillData("CRAFTING");
        for (SkillData skill : skills) {
            CraftingData craftingData = (CraftingData)skill;
            NamespacedKey namespacedKey = ((Keyed)craftingData.getRecipe()).getKey();
            e.getPlayer().undiscoverRecipe(namespacedKey);
        }
    }

    @EventHandler
    public void onReload(SuperheroesReloadEvent e) {
        Collection<Superhero> values = Superheroes.getInstance().getHeroHandler().getNameToSuperhero().values();
        for (Superhero hero : values) {
            Collection<SkillData> skills = hero.getSkillData("CRAFTING");
            for (SkillData skill : skills) {
                CraftingData craftingData = (CraftingData)skill;
                NamespacedKey namespacedKey = ((Keyed)craftingData.getRecipe()).getKey();
                Bukkit.removeRecipe((NamespacedKey)namespacedKey);
            }
        }
        this.discoverForAllLate();
    }

    public void discoverForAllLate() {
        Bukkit.getOnlinePlayers().forEach(player -> Superheroes.getFoliaHacks().getScheduling().entitySpecificScheduler((Entity)player).runDelayed(() -> {
            Superhero superhero = this.heroHandler.getSuperhero((Player)player);
            this.discoverRecipes((Player)player, superhero);
        }, () -> {}, 5L));
    }

    @EventHandler
    public void prepareCrafting(PrepareItemCraftEvent e) {
        Recipe eventRecipe = e.getRecipe();
        NamespacedKey eventKey = null;
        if (eventRecipe instanceof Keyed && !(eventKey = ((Keyed)eventRecipe).getKey()).getNamespace().equals("superheroes")) {
            return;
        }
        if (eventKey == null) {
            return;
        }
        e.getInventory().setResult(new ItemStack(Material.AIR));
        List viewers = e.getViewers();
        for (HumanEntity humanEntity : viewers) {
            if (!(humanEntity instanceof Player)) continue;
            Player player = (Player)humanEntity;
            Superhero superhero = this.heroHandler.getSuperhero(player);
            Collection<SkillData> skills = superhero.getSkillData("CRAFTING");
            for (SkillData skill : skills) {
                CraftingData craftingData = (CraftingData)skill;
                NamespacedKey namespacedKey = ((Keyed)craftingData.getRecipe()).getKey();
                if (!namespacedKey.equals((Object)eventKey)) continue;
                craftingData.ifConditionsTrue(() -> e.getInventory().setResult(new ItemStack(eventRecipe.getResult())), player, new Object[0]);
            }
        }
    }
}

