/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.Collection;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.events.PlayerChangedSuperheroEvent;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.DamagePotionData;
import me.xemor.superheroes.skills.skilldata.SkillData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;

public class DamagePotionSkill
extends SkillImplementation {
    public DamagePotionSkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onDamage(EntityDamageEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Superhero superhero = this.heroHandler.getSuperhero(player);
        Collection<SkillData> skillDatas = superhero.getSkillData("DAMAGEPOTION");
        for (SkillData skillData : skillDatas) {
            DamagePotionData damagePotionData = (DamagePotionData)skillData;
            if (!damagePotionData.isValidDamageCause(e.getCause())) continue;
            damagePotionData.getPotionEffect().ifPresent(potionEffect -> {
                if (!player.hasPotionEffect(potionEffect.getType())) {
                    damagePotionData.ifConditionsTrue(() -> player.addPotionEffect(potionEffect), player, new Object[0]);
                }
            });
        }
    }

    @EventHandler
    public void onPowerLoss(PlayerChangedSuperheroEvent e) {
        Player player = e.getPlayer();
        Superhero superhero = e.getOldHero();
        Collection<SkillData> skillDatas = superhero.getSkillData("DAMAGEPOTION");
        if (!skillDatas.isEmpty()) {
            for (SkillData skillData : skillDatas) {
                DamagePotionData damagePotionData = (DamagePotionData)skillData;
                damagePotionData.getPotionEffect().ifPresent(potionEffect -> player.removePotionEffect(potionEffect.getType()));
            }
        }
    }
}

