/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.events.PlayerChangedSuperheroEvent;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.DecoyData;
import me.xemor.superheroes.skills.skilldata.SkillData;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class DecoySkill
extends SkillImplementation {
    final HashMap<SkillData, HashMap<UUID, UUID>> playerToDecoy = new HashMap();
    final NamespacedKey namespacedKey;

    public DecoySkill(HeroHandler heroHandler) {
        super(heroHandler);
        this.namespacedKey = new NamespacedKey((Plugin)heroHandler.getPlugin(), "decoy");
    }

    @EventHandler
    public void disableSlots(PlayerArmorStandManipulateEvent e) {
        ArmorStand armorStand = e.getRightClicked();
        if (armorStand.getPersistentDataContainer().has(this.namespacedKey, PersistentDataType.INTEGER)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onSneak(PlayerToggleSneakEvent e) {
        Player player = e.getPlayer();
        Superhero superhero = this.heroHandler.getSuperhero(player);
        Collection<SkillData> skillDatas = superhero.getSkillData("DECOY");
        for (SkillData skillData : skillDatas) {
            DecoyData decoyData = (DecoyData)skillData;
            this.removeArmorStand(player, decoyData);
            if (!e.isSneaking()) continue;
            decoyData.ifConditionsTrue(() -> {
                ArmorStand armorStand = this.createArmorStand(player, decoyData);
                HashMap<UUID, UUID> hashMap = this.playerToDecoy.getOrDefault(decoyData, new HashMap());
                hashMap.put(player.getUniqueId(), armorStand.getUniqueId());
                this.playerToDecoy.put(skillData, hashMap);
            }, player, new Object[0]);
        }
    }

    public void removeArmorStand(Player player, DecoyData decoyData) {
        HashMap hashMap = this.playerToDecoy.getOrDefault(decoyData, new HashMap());
        UUID armorStandUUID = (UUID)hashMap.get(player.getUniqueId());
        if (armorStandUUID != null) {
            Entity entity = Bukkit.getEntity((UUID)armorStandUUID);
            if (entity != null) {
                entity.remove();
            }
            hashMap.remove(player.getUniqueId());
            this.playerToDecoy.put(decoyData, hashMap);
        }
    }

    public ArmorStand createArmorStand(Player player, DecoyData decoyData) {
        World world = player.getWorld();
        ArmorStand armorStand = (ArmorStand)world.spawn(player.getLocation(), ArmorStand.class);
        armorStand.setBasePlate(false);
        EntityEquipment entityEquipment = armorStand.getEquipment();
        entityEquipment.setHelmet(decoyData.getSkull(player));
        entityEquipment.setChestplate(this.createLeatherGear(Material.LEATHER_CHESTPLATE, decoyData));
        entityEquipment.setLeggings(this.createLeatherGear(Material.LEATHER_LEGGINGS, decoyData));
        entityEquipment.setBoots(this.createLeatherGear(Material.LEATHER_BOOTS, decoyData));
        armorStand.setInvulnerable(true);
        armorStand.setArms(true);
        armorStand.setCustomName("Decoy");
        armorStand.getPersistentDataContainer().set(this.namespacedKey, PersistentDataType.INTEGER, (Object)0);
        return armorStand;
    }

    public ItemStack createLeatherGear(@NotNull Material leatherArmor, DecoyData decoyData) {
        ItemStack itemStack = new ItemStack(leatherArmor);
        LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemStack.getItemMeta();
        leatherArmorMeta.setColor(decoyData.getColor());
        itemStack.setItemMeta((ItemMeta)leatherArmorMeta);
        return itemStack;
    }

    @EventHandler
    public void onLost(PlayerChangedSuperheroEvent e) {
        Superhero superhero = e.getOldHero();
        Collection<SkillData> skillDatas = superhero.getSkillData("DECOY");
        for (SkillData skillData : skillDatas) {
            this.removeArmorStand(e.getPlayer(), (DecoyData)skillData);
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        Superhero superhero = this.heroHandler.getSuperhero(e.getPlayer());
        Collection<SkillData> skillDatas = superhero.getSkillData("DECOY");
        for (SkillData skillData : skillDatas) {
            this.removeArmorStand(e.getPlayer(), (DecoyData)skillData);
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent e) {
        Superheroes.getScheduling().regionSpecificScheduler(e.getWorld(), e.getChunk().getX(), e.getChunk().getZ()).runDelayed(() -> this.removeDecoys(e.getChunk()), 50L);
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent e) {
        Superheroes.getScheduling().regionSpecificScheduler(e.getWorld(), e.getChunk().getX(), e.getChunk().getZ()).runDelayed(() -> this.removeDecoys(e.getChunk()), 50L);
    }

    public void removeDecoys(Chunk chunk) {
        if (chunk.isEntitiesLoaded()) {
            Entity[] entities;
            for (Entity entity : entities = chunk.getEntities()) {
                if (!(entity instanceof ArmorStand) || !"Decoy".equals(entity.getCustomName()) || !entity.getPersistentDataContainer().has(this.namespacedKey, PersistentDataType.INTEGER)) continue;
                entity.remove();
            }
        }
    }
}

