/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.Collection;
import me.xemor.superheroes.SkillCooldownHandler;
import me.xemor.superheroes.configurationdata.SoundData;
import me.xemor.superheroes.configurationdata.particles.ParticleData;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.GunData;
import me.xemor.superheroes.skills.skilldata.SkillData;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class GunSkill
extends SkillImplementation {
    final SkillCooldownHandler skillCooldownHandler = new SkillCooldownHandler();

    public GunSkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void useGun(PlayerInteractEvent e) {
        if (e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Collection<SkillData> skillDatas = this.heroHandler.getSuperhero(e.getPlayer()).getSkillData("GUN");
            Player player = e.getPlayer();
            for (SkillData skillData : skillDatas) {
                GunData gunData = (GunData)skillData;
                if (!gunData.getItemComparison().matches(e.getItem()) || !this.skillCooldownHandler.isCooldownOver(gunData, player.getUniqueId())) continue;
                Location currentLocation = player.getEyeLocation();
                Vector increment = player.getEyeLocation().getDirection();
                World world = player.getWorld();
                SoundData shootSound = gunData.getShootSound();
                world.playSound(player.getEyeLocation(), shootSound.sound(), shootSound.volume(), shootSound.pitch());
                RayTraceResult rayTraceResult = world.rayTrace(currentLocation, increment, gunData.getMaxDistance(), FluidCollisionMode.NEVER, true, gunData.getBulletSize(), entity -> (entity instanceof LivingEntity || entity instanceof EnderCrystal) && !player.equals(entity));
                this.skillCooldownHandler.startCooldown(gunData, gunData.getCooldown(), player.getUniqueId());
                ParticleData trailData = gunData.getTrailParticle();
                int i = 0;
                while ((double)i < gunData.getMaxDistance()) {
                    trailData.spawnParticle(currentLocation);
                    currentLocation = currentLocation.add(increment);
                    ++i;
                }
                if (rayTraceResult == null) {
                    return;
                }
                Entity entity2 = rayTraceResult.getHitEntity();
                if (entity2 instanceof EnderCrystal) {
                    EnderCrystal enderCrystal = (EnderCrystal)entity2;
                    world.createExplosion(enderCrystal.getLocation(), 6.0f);
                    enderCrystal.remove();
                    return;
                }
                LivingEntity livingEntity = (LivingEntity)rayTraceResult.getHitEntity();
                if (livingEntity == null) {
                    return;
                }
                skillData.ifConditionsTrue(() -> {
                    if (livingEntity instanceof EnderDragon) {
                        double newHealth = livingEntity.getHealth() - gunData.getDamage();
                        if (newHealth < 0.0) {
                            return;
                        }
                        livingEntity.setHealth(newHealth);
                    }
                    livingEntity.damage(gunData.getDamage(), (Entity)player);
                    ParticleData hitParticle = gunData.getHitParticle();
                    hitParticle.spawnParticle(livingEntity.getLocation().add(0.0, 1.0, 0.0));
                }, player, livingEntity);
            }
        }
    }
}

