/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.List;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.LifestealData;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class LifestealSkill
extends SkillImplementation {
    public LifestealSkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onDamageEntity(EntityDamageByEntityEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Entity entity = e.getDamager();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Superhero superhero = this.heroHandler.getSuperhero(player);
            List<LifestealData> lifestealDatas = superhero.getSkillData(LifestealData.class);
            for (LifestealData lifestealData : lifestealDatas) {
                lifestealData.ifConditionsTrue(() -> {
                    double maxHealth = player.getAttribute(Attribute.MAX_HEALTH).getValue();
                    if (player.getHealth() >= maxHealth) {
                        return;
                    }
                    double lifesteal = e.getFinalDamage() * lifestealData.getLifestealPercentage();
                    if (player.getHealth() + lifesteal >= maxHealth) {
                        player.setHealth(maxHealth);
                        return;
                    }
                    player.setHealth(player.getHealth() + lifesteal);
                }, player, e.getEntity());
            }
        }
    }
}

