/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.Collection;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.events.PlayerChangedSuperheroEvent;
import me.xemor.superheroes.events.SuperheroPlayerJoinEvent;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.LightSkillData;
import me.xemor.superheroes.skills.skilldata.SkillData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.potion.PotionEffect;

public class LightSkill
extends SkillImplementation {
    public LightSkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onGain(PlayerChangedSuperheroEvent e) {
        Superhero superhero = e.getNewHero();
        if (superhero.hasSkill("LIGHT")) {
            this.runnable(e.getPlayer(), superhero);
        }
    }

    @EventHandler
    public void onLost(PlayerChangedSuperheroEvent e) {
        Superhero superhero = e.getOldHero();
        Collection<SkillData> skillDatas = superhero.getSkillData("LIGHT");
        for (SkillData skillData : skillDatas) {
            LightSkillData lightData = (LightSkillData)skillData;
            lightData.getPotionEffect().ifPresent(potionEffect -> e.getPlayer().removePotionEffect(potionEffect.getType()));
        }
    }

    @EventHandler
    public void onJoin(SuperheroPlayerJoinEvent e) {
        if (e.getSuperhero().hasSkill("LIGHT")) {
            this.runnable(e.getPlayer(), e.getSuperhero());
        }
    }

    public void runnable(Player player, Superhero superhero) {
        Superheroes.getScheduling().entitySpecificScheduler((Entity)player).runAtFixedRate(task -> {
            Collection<SkillData> data = superhero.getSkillData("LIGHT");
            if (data.isEmpty()) {
                task.cancel();
                return;
            }
            if (this.heroHandler.getSuperhero(player) != superhero) {
                task.cancel();
                return;
            }
            for (SkillData skillData : data) {
                LightSkillData lightData = (LightSkillData)skillData;
                if (player.getWorld().getBlockAt(player.getLocation()).getLightLevel() > 10) {
                    lightData.areConditionsTrue(player, new Object[0]).thenAccept(b -> {
                        if (b.booleanValue()) {
                            lightData.getPotionEffect().ifPresent(arg_0 -> ((Player)player).addPotionEffect(arg_0));
                        } else {
                            lightData.getPotionEffect().map(PotionEffect::getType).ifPresent(arg_0 -> ((Player)player).removePotionEffect(arg_0));
                        }
                    });
                    continue;
                }
                lightData.getPotionEffect().map(PotionEffect::getType).ifPresent(arg_0 -> ((Player)player).removePotionEffect(arg_0));
            }
        }, () -> {}, 1L, 20L);
    }
}

