/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.Collection;
import java.util.List;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.events.PlayerChangedSuperheroEvent;
import me.xemor.superheroes.foliahacks.PlayerPostRespawnFoliaEvent;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.PotionEffectSkillData;
import me.xemor.superheroes.skills.skilldata.SkillData;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionEffectSkill
extends SkillImplementation {
    public PotionEffectSkill(HeroHandler heroHandler) {
        super(heroHandler);
        Superheroes.getScheduling().globalRegionalScheduler().runAtFixedRate(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                Superheroes.getScheduling().entitySpecificScheduler((Entity)player).run(() -> this.givePotionEffects(player, heroHandler.getSuperhero(player)), () -> {});
            }
        }, 1L, 20L);
    }

    @EventHandler
    public void onPowerGained(PlayerChangedSuperheroEvent e) {
        this.givePotionEffects(e.getPlayer(), e.getNewHero());
    }

    public void givePotionEffects(Player player, Superhero superhero) {
        List<PotionEffectSkillData> potionEffectSkillDatas = superhero.getSkillData(PotionEffectSkillData.class);
        if (potionEffectSkillDatas != null) {
            for (PotionEffectSkillData potionEffectSkillData : potionEffectSkillDatas) {
                potionEffectSkillData.ifConditionsTrue(() -> potionEffectSkillData.getPotionEffect().ifPresent(effectToApply -> {
                    PotionEffect potionEffect;
                    if (effectToApply.getType().equals(PotionEffectType.HEALTH_BOOST) && (potionEffect = player.getPotionEffect(effectToApply.getType())) != null && potionEffect.getDuration() > 2) {
                        return;
                    }
                    player.addPotionEffect(effectToApply);
                }), player, new Object[0]);
            }
        }
    }

    @EventHandler
    public void onRespawn(PlayerPostRespawnFoliaEvent e) {
        Superheroes.getScheduling().entitySpecificScheduler((Entity)e.getPlayer()).runDelayed(() -> this.givePotionEffects(e.getPlayer(), Superheroes.getInstance().getHeroHandler().getSuperhero(e.getPlayer())), () -> {}, 5L);
    }

    @EventHandler
    public void onPowerLost(PlayerChangedSuperheroEvent e) {
        Collection<SkillData> skillDatas = e.getOldHero().getSkillData("POTIONEFFECT");
        if (skillDatas != null) {
            for (SkillData skillData : skillDatas) {
                if (!(skillData instanceof PotionEffectSkillData)) continue;
                PotionEffectSkillData potionEffectData = (PotionEffectSkillData)skillData;
                potionEffectData.getPotionEffect().map(PotionEffect::getType).ifPresent(arg_0 -> ((Player)e.getPlayer()).removePotionEffect(arg_0));
            }
        }
    }

    @EventHandler
    public void onMilkDrink(PlayerItemConsumeEvent e) {
        if (e.getItem().getType() == Material.MILK_BUCKET) {
            Superheroes.getScheduling().entitySpecificScheduler((Entity)e.getPlayer()).runDelayed(() -> this.givePotionEffects(e.getPlayer(), Superheroes.getInstance().getHeroHandler().getSuperhero(e.getPlayer())), () -> {}, 3L);
        }
    }
}

