/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.Collection;
import java.util.function.Predicate;
import me.xemor.superheroes.SkillCooldownHandler;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.RemoteDetonationData;
import me.xemor.superheroes.skills.skilldata.SkillData;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.util.RayTraceResult;

public class RemoteDetonationSkill
extends SkillImplementation {
    final SkillCooldownHandler skillCooldownHandler = new SkillCooldownHandler();

    public RemoteDetonationSkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onShift(PlayerToggleSneakEvent e) {
        if (e.isSneaking()) {
            Player player = e.getPlayer();
            Collection<SkillData> skillDatas = this.heroHandler.getSuperhero(player).getSkillData("REMOTEDETONATION");
            for (SkillData skillData : skillDatas) {
                RemoteDetonationData remoteDetonationData = (RemoteDetonationData)skillData;
                if (!this.skillCooldownHandler.isCooldownOver(remoteDetonationData, player.getUniqueId())) continue;
                Entity entity = this.raytrace(player, remoteDetonationData::isExplodable);
                if (entity == null) {
                    return;
                }
                skillData.ifConditionsTrue(() -> {
                    Location location = entity.getLocation();
                    if (!(entity instanceof Player) && remoteDetonationData.removeDetonatedEntity()) {
                        if (entity instanceof LivingEntity) {
                            ((LivingEntity)entity).setHealth(0.0);
                        } else {
                            entity.remove();
                        }
                    }
                    World world = player.getWorld();
                    world.createExplosion(location, remoteDetonationData.getExplosionStrength(), remoteDetonationData.spawnsFire(), remoteDetonationData.breakBlocks(), entity);
                    this.skillCooldownHandler.startCooldown(remoteDetonationData, player.getUniqueId());
                }, player, entity);
            }
        }
    }

    public Entity raytrace(Player player, Predicate<EntityType> isExplodable) {
        World world = player.getWorld();
        RayTraceResult rayTraceResult = world.rayTraceEntities(player.getEyeLocation(), player.getEyeLocation().getDirection(), 32.0, 0.5, entity -> entity != player && isExplodable.test(entity.getType()));
        if (rayTraceResult == null) {
            return null;
        }
        return rayTraceResult.getHitEntity();
    }
}

