/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.Collection;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.events.PlayerChangedSuperheroEvent;
import me.xemor.superheroes.events.SuperheroPlayerJoinEvent;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.SkillData;
import me.xemor.superheroes.skills.skilldata.SneakingPotionData;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.potion.PotionEffect;

public class SneakingPotionSkill
extends SkillImplementation {
    public SneakingPotionSkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onSneak(PlayerToggleSneakEvent e) {
        Player player = e.getPlayer();
        Superhero superhero = this.getPowersHandler().getSuperhero(player);
        Collection<SkillData> skillDatas = superhero.getSkillData("SNEAKINGPOTION");
        for (SkillData skillData : skillDatas) {
            SneakingPotionData sneakingPotionData = (SneakingPotionData)skillData;
            if (e.isSneaking()) {
                skillData.ifConditionsTrue(() -> sneakingPotionData.getPotionEffect().ifPresent(arg_0 -> ((Player)e.getPlayer()).addPotionEffect(arg_0)), player, new Object[0]);
                continue;
            }
            sneakingPotionData.getPotionEffect().ifPresent(potionEffect -> e.getPlayer().removePotionEffect(potionEffect.getType()));
        }
    }

    @EventHandler
    public void onPowerLost(PlayerChangedSuperheroEvent e) {
        Collection<SkillData> skillDatas = e.getOldHero().getSkillData("SNEAKINGPOTION");
        if (skillDatas != null) {
            for (SkillData skillData : skillDatas) {
                SneakingPotionData sneakingPotionSkill = (SneakingPotionData)skillData;
                sneakingPotionSkill.getPotionEffect().map(PotionEffect::getType).ifPresent(arg_0 -> ((Player)e.getPlayer()).removePotionEffect(arg_0));
            }
        }
    }

    @EventHandler
    public void onJoin(SuperheroPlayerJoinEvent e) {
        Superhero superhero = e.getSuperhero();
        Collection<SkillData> skillDatas = superhero.getSkillData("SNEAKINGPOTION");
        for (SkillData skillData : skillDatas) {
            SneakingPotionData sneakingPotionData = (SneakingPotionData)skillData;
            sneakingPotionData.getPotionEffect().map(PotionEffect::getType).ifPresent(arg_0 -> ((Player)e.getPlayer()).removePotionEffect(arg_0));
        }
    }
}

