/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.Collection;
import java.util.List;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.events.PlayerChangedSuperheroEvent;
import me.xemor.superheroes.kyori.adventure.audience.Audience;
import me.xemor.superheroes.kyori.adventure.text.Component;
import me.xemor.superheroes.kyori.adventure.text.minimessage.MiniMessage;
import me.xemor.superheroes.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import me.xemor.superheroes.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.SkillData;
import me.xemor.superheroes.skills.skilldata.StrongmanData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.util.Vector;

public class StrongmanSkill
extends SkillImplementation {
    public StrongmanSkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onInteract(PlayerInteractEntityEvent e) {
        Player player = e.getPlayer();
        Superhero superhero = this.heroHandler.getSuperhero(player);
        List<StrongmanData> strongmanDatas = superhero.getSkillData(StrongmanData.class);
        for (StrongmanData strongmanData : strongmanDatas) {
            Entity topEntity = this.getTopEntity((Entity)e.getPlayer());
            strongmanData.ifConditionsTrue(() -> {
                if (!e.getRightClicked().equals((Object)topEntity) && this.countPassengers(topEntity) <= strongmanData.getMaxPassengers()) {
                    topEntity.addPassenger(e.getRightClicked());
                }
                if (e.getRightClicked() instanceof Vehicle) {
                    Component tooMuscular = MiniMessage.miniMessage().deserialize(strongmanData.getTooMuscularMessage(), (TagResolver)Placeholder.unparsed("player", player.getName()));
                    Audience playerAudience = Superheroes.getBukkitAudiences().player(player);
                    playerAudience.sendActionBar(tooMuscular);
                }
            }, player, e.getRightClicked());
        }
    }

    public Entity getTopEntity(Entity entity) {
        if (!entity.getPassengers().isEmpty()) {
            return this.getTopEntity((Entity)entity.getPassengers().get(0));
        }
        return entity;
    }

    public int countPassengers(Entity entity) {
        int x = 0;
        if (!entity.getPassengers().isEmpty()) {
            return this.countPassengers((Entity)entity.getPassengers().get(0), ++x);
        }
        return x;
    }

    public int countPassengers(Entity entity, int x) {
        if (!entity.getPassengers().isEmpty()) {
            return this.countPassengers((Entity)entity.getPassengers().get(0), ++x);
        }
        return x;
    }

    @EventHandler
    public void onSneak(PlayerToggleSneakEvent e) {
        Player player = e.getPlayer();
        Superhero superhero = this.heroHandler.getSuperhero(player);
        Collection<SkillData> skillDatas = superhero.getSkillData("STRONGMAN");
        for (SkillData skillData : skillDatas) {
            StrongmanData strongmanData = (StrongmanData)skillData;
            if (!e.isSneaking()) continue;
            while (!player.getPassengers().isEmpty()) {
                Entity topEntity = this.getTopEntity((Entity)player);
                Vector velocity = player.getEyeLocation().getDirection().normalize();
                velocity.setX(velocity.getX() * strongmanData.getVelocity());
                velocity.setZ(velocity.getZ() * strongmanData.getVelocity());
                velocity.setY(velocity.getY() * strongmanData.getUpwardsVelocity());
                topEntity.getVehicle().removePassenger(topEntity);
                for (long i = 1L; i < 3L; ++i) {
                    Superheroes.getScheduling().entitySpecificScheduler(topEntity).runDelayed(() -> topEntity.setVelocity(velocity), () -> {}, i);
                }
            }
        }
    }

    @EventHandler
    public void onLostPower(PlayerChangedSuperheroEvent e) {
        Player player = e.getPlayer();
        Superhero superhero = e.getOldHero();
        Collection<SkillData> skillDatas = superhero.getSkillData("STRONGMAN");
        for (SkillData skillData : skillDatas) {
            StrongmanData strongmanData = (StrongmanData)skillData;
            while (player.getPassengers().size() > 0) {
                Entity topEntity = this.getTopEntity((Entity)player);
                Vector velocity = player.getEyeLocation().getDirection().normalize();
                velocity.setX(velocity.getX() * strongmanData.getVelocity());
                velocity.setZ(velocity.getZ() * strongmanData.getVelocity());
                velocity.setY(velocity.getY() * strongmanData.getUpwardsVelocity());
                topEntity.getVehicle().removePassenger(topEntity);
                Superheroes.getScheduling().entitySpecificScheduler(topEntity).runDelayed(() -> topEntity.setVelocity(velocity), () -> {}, 1L);
            }
        }
    }
}

