/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.List;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.WalkerData;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class WalkerSkill
extends SkillImplementation {
    public WalkerSkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onMove(PlayerMoveEvent e) {
        Player player = e.getPlayer();
        Superhero superhero = this.heroHandler.getSuperhero(player);
        List<WalkerData> walkerDatas = superhero.getSkillData(WalkerData.class);
        if (player.isInsideVehicle()) {
            return;
        }
        for (WalkerData walkerData : walkerDatas) {
            if (walkerData.isSneaking() != e.getPlayer().isSneaking()) continue;
            Location location = e.getTo();
            if (e.getTo() == null) continue;
            World world = player.getWorld();
            Block block = walkerData.isAboveFloor() ? world.getBlockAt(location) : world.getBlockAt(location.clone().subtract(0.0, 1.0, 0.0));
            Material belowBlock = block.getRelative(BlockFace.DOWN).getType();
            if (!walkerData.canPlaceFloating() && !belowBlock.isSolid() || !walkerData.canPlaceOn(belowBlock)) continue;
            Material originalMaterial = block.getType();
            if (!walkerData.shouldReplace(block.getType())) continue;
            walkerData.ifConditionsTrue(() -> {
                Material newMaterial = walkerData.getReplacementBlock();
                block.setType(newMaterial, false);
                block.setMetadata("blockDrops", (MetadataValue)new FixedMetadataValue((Plugin)this.heroHandler.getPlugin(), (Object)walkerData.doesBlockDrop()));
                if (walkerData.shouldRevert()) {
                    this.revertRunnable(walkerData, block, newMaterial, originalMaterial);
                }
            }, player, block.getLocation());
        }
    }

    public void revertRunnable(WalkerData walkerData, Block block, Material newMaterial, Material originalMaterial) {
        Superheroes.getScheduling().regionSpecificScheduler(block.getLocation()).runDelayed(() -> {
            block.removeMetadata("blockDrops", (Plugin)this.heroHandler.getPlugin());
            if (newMaterial == block.getType()) {
                block.setType(originalMaterial);
            }
        }, walkerData.getRevertsAfter());
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        if (e.getBlock().hasMetadata("blockDrops")) {
            e.setDropItems(((MetadataValue)e.getBlock().getMetadata("blockDrops").get(0)).asBoolean());
        }
    }
}

