/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.skilldata;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.concurrent.CompletableFuture;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.configurationdata.JsonPropertyWithDefault;
import me.xemor.superheroes.skills.ConditionListWrapper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="skill", visible=true)
public abstract class SkillData {
    @JsonPropertyWithDefault
    private ConditionListWrapper conditions = new ConditionListWrapper();
    @JsonPropertyWithDefault
    private String skill;
    @JsonPropertyWithDefault
    @JsonAlias(value={"respect_protection_plugins"})
    private boolean respectProtectionPlugins = true;

    public CompletableFuture<Boolean> areConditionsTrue(Player player, Object ... objects) {
        if (this.conditions.getConditionListIfSkillsLibraryPresent().isEmpty()) {
            return CompletableFuture.completedFuture(true);
        }
        return this.conditions.getConditionListIfSkillsLibraryPresent().orElseThrow().ANDConditions((Entity)player, false, objects);
    }

    public void ifConditionsTrue(Runnable runnable, Player player, Object ... objects) {
        if (this.conditions == null) {
            runnable.run();
        }
        this.areConditionsTrue(player, objects).thenAccept(b -> {
            if (b.booleanValue()) {
                runnable.run();
            }
        });
    }

    public ConditionListWrapper getConditions() {
        if (!Superheroes.getInstance().hasSkillsLibrary()) {
            Superheroes.getInstance().getLogger().warning("PLEASE REPORT THIS MESSAGE TO XEMOR IN THE DISCORD! getConditions() called without SkillsLibrary");
        }
        return this.conditions;
    }

    public boolean shouldRespectProtectionPlugins() {
        return this.respectProtectionPlugins;
    }

    public String getSkill() {
        return this.skill;
    }
}

