/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.skilldata.spell;

import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.List;
import me.xemor.superheroes.skills.skilldata.spell.ExplosionSpell;
import me.xemor.superheroes.skills.skilldata.spell.FangsSpell;
import me.xemor.superheroes.skills.skilldata.spell.LaunchProjectileSpell;
import me.xemor.superheroes.skills.skilldata.spell.LightningSpell;
import me.xemor.superheroes.skills.skilldata.spell.PlaceBlockSpell;
import me.xemor.superheroes.skills.skilldata.spell.SpellData;
import me.xemor.superheroes.skills.skilldata.spell.TransmutationSpell;

public class Spells {
    private static final HashBiMap<String, Integer> nameToSpell = HashBiMap.create();
    private static final List<Class<? extends SpellData>> spellToData = new ArrayList<Class<? extends SpellData>>();
    private static int counter = 0;

    public static void registerSpell(String name, Class<? extends SpellData> clazz) {
        nameToSpell.put((Object)name, (Object)counter);
        spellToData.add(clazz);
        ++counter;
    }

    public static int getSpell(String name) {
        return (Integer)nameToSpell.getOrDefault((Object)name, (Object)-1);
    }

    public static String getName(int effect) {
        return (String)nameToSpell.inverse().get((Object)effect);
    }

    public static NamedType[] getNamedTypes() {
        return (NamedType[])nameToSpell.entrySet().stream().map(entry -> new NamedType(spellToData.get((Integer)entry.getValue()), (String)entry.getKey() + "_SPELL")).toArray(NamedType[]::new);
    }

    static {
        Spells.registerSpell("TRANSMUTATION", TransmutationSpell.class);
        Spells.registerSpell("BLOCK", PlaceBlockSpell.class);
        Spells.registerSpell("PROJECTILE", LaunchProjectileSpell.class);
        Spells.registerSpell("LIGHTNING", LightningSpell.class);
        Spells.registerSpell("EXPLOSION", ExplosionSpell.class);
        Spells.registerSpell("FANGS", FangsSpell.class);
    }
}

