/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.userinterface;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class InventoryInteractions<T>
implements InventoryHolder {
    @Nullable
    private Consumer<Player> closeInteraction;
    private final Map<Predicate<ItemStack>, Interaction> map = new HashMap<Predicate<ItemStack>, Interaction>();
    private Inventory inventory;
    private boolean isClosed;
    private final T data;

    public InventoryInteractions(T data) {
        this.data = data;
    }

    @NotNull
    public Inventory getInventory() {
        if (this.inventory == null) {
            throw new IllegalArgumentException("InventoryInterface has not been constructed correctly. You have to pass the inventory usingInventoryInterface#setInventory");
        }
        return this.inventory;
    }

    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    public void addCloseInteraction(Consumer<Player> consumer) {
        this.closeInteraction = consumer;
    }

    public void closed(Player player) {
        this.isClosed = true;
        if (this.closeInteraction != null) {
            this.closeInteraction.accept(player);
        }
    }

    public void addInteraction(Predicate<ItemStack> predicate, Interaction interaction) {
        this.map.put(predicate, interaction);
    }

    public void addSimpleInteraction(ItemStack item, Consumer<Player> consumer) {
        this.map.put(arg_0 -> ((ItemStack)item).equals(arg_0), (player, otherItem, clickType) -> {
            if (clickType == ClickType.LEFT || clickType == ClickType.RIGHT) {
                consumer.accept(player);
            }
        });
    }

    public void interact(ItemStack item, Player player, ClickType clickType) {
        for (Map.Entry<Predicate<ItemStack>, Interaction> entry : this.map.entrySet()) {
            if (!entry.getKey().test(item)) continue;
            entry.getValue().run(player, item, clickType);
        }
    }

    public T getData() {
        return this.data;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public static interface Interaction {
        public void run(Player var1, ItemStack var2, ClickType var3);
    }
}

