/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.core.item;

import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Objects;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ArchitecturySpawnEggItem
extends SpawnEggItem {
    private static final Logger LOGGER = LogManager.getLogger(ArchitecturySpawnEggItem.class);
    private final RegistrySupplier<? extends EntityType<? extends Mob>> entityType;

    protected static DispenseItemBehavior createDispenseItemBehavior() {
        return new DefaultDispenseItemBehavior(){

            public ItemStack m_7498_(BlockSource source, ItemStack stack) {
                Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                EntityType entityType = ((SpawnEggItem)stack.m_41720_()).m_43228_(stack.m_41783_());
                try {
                    entityType.m_20592_(source.m_7727_(), stack, null, source.m_7961_().m_121945_(direction), MobSpawnType.DISPENSER, direction != Direction.UP, false);
                }
                catch (Exception var6) {
                    f_181892_.error("Error while dispensing spawn egg from dispenser at {}", (Object)source.m_7961_(), (Object)var6);
                    return ItemStack.f_41583_;
                }
                stack.m_41774_(1);
                source.m_7727_().m_142346_(null, GameEvent.f_157810_, source.m_7961_());
                return stack;
            }
        };
    }

    public ArchitecturySpawnEggItem(RegistrySupplier<? extends EntityType<? extends Mob>> entityType, int backgroundColor, int highlightColor, Item.Properties properties) {
        this(entityType, backgroundColor, highlightColor, properties, ArchitecturySpawnEggItem.createDispenseItemBehavior());
    }

    public ArchitecturySpawnEggItem(RegistrySupplier<? extends EntityType<? extends Mob>> entityType, int backgroundColor, int highlightColor, Item.Properties properties, @Nullable DispenseItemBehavior dispenseItemBehavior) {
        super(null, backgroundColor, highlightColor, properties);
        this.entityType = Objects.requireNonNull(entityType, "entityType");
        SpawnEggItem.f_43201_.remove(null);
        entityType.listen(type -> {
            LOGGER.debug("Registering spawn egg {} for {}", (Object)this.toString(), (Object)Objects.toString(type.arch$registryName()));
            SpawnEggItem.f_43201_.put(type, this);
            this.f_43204_ = type;
            if (dispenseItemBehavior != null) {
                DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)dispenseItemBehavior);
            }
        });
    }

    public EntityType<?> m_43228_(@Nullable CompoundTag compoundTag) {
        EntityType type = super.m_43228_(compoundTag);
        return type == null ? (EntityType)this.entityType.get() : type;
    }
}

