/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.extras.darkness;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import org.embeddedt.embeddium.extras.ExtrasConfig;
import org.embeddedt.embeddium.extras.ExtrasTools;

public class DarknessPlus {
    public static final double MIN = 0.03;
    public static boolean enabled = false;
    private static final float[][] LUMINANCE = new float[16][16];

    public static Vec3 getDarkFogColor(Vec3 vanilla, double factor) {
        if (factor == 1.0) {
            return vanilla;
        }
        return new Vec3(Math.max(0.03, vanilla.f_82479_ * factor), Math.max(0.03, vanilla.f_82480_ * factor), Math.max(0.03, vanilla.f_82481_ * factor));
    }

    private static boolean isDark(Level world) {
        if (ExtrasConfig.darknessMode.get() == ExtrasConfig.DarknessMode.OFF) {
            return false;
        }
        ResourceKey dimType = world.m_46472_();
        if (dimType == Level.f_46428_) {
            return ExtrasConfig.darknessOnOverworldCache;
        }
        if (dimType == Level.f_46429_) {
            return ExtrasConfig.darknessOnNetherCache;
        }
        if (dimType == Level.f_46430_) {
            return ExtrasConfig.darknessOnEndCache;
        }
        if (ExtrasTools.isWhitelisted(dimType.m_135782_(), ExtrasConfig.darknessDimensionWhiteList)) {
            return true;
        }
        if (world.m_6042_().f_223549_()) {
            return ExtrasConfig.darknessByDefaultCache;
        }
        return ExtrasConfig.darknessOnNoSkyLightCache;
    }

    private static float skyFactor(Level world) {
        if (ExtrasConfig.darknessBlockLightOnlyCache || !DarknessPlus.isDark(world)) {
            return 1.0f;
        }
        if (!world.m_6042_().f_223549_()) {
            return 0.0f;
        }
        float angle = world.m_46942_(0.0f);
        if (!(angle > 0.25f) || !(angle < 0.75f)) {
            return 1.0f;
        }
        float oldWeight = Math.max(0.0f, Math.abs(angle - 0.5f) - 0.2f) * 20.0f;
        float moon = ExtrasConfig.darknessAffectedByMoonPhaseCache ? world.m_46940_() : 0.0f;
        float moonInterpolated = (float)Mth.m_14139_((double)moon, (double)ExtrasConfig.darknessNewMoonBrightCache, (double)ExtrasConfig.darknessFullMoonBrightCache);
        return Mth.m_14179_((float)(oldWeight * oldWeight * oldWeight), (float)moonInterpolated, (float)1.0f);
    }

    public static int darken(int c, int blockIndex, int skyIndex) {
        float lTarget = LUMINANCE[blockIndex][skyIndex];
        float r = (float)(c & 0xFF) / 255.0f;
        float g = (float)(c >> 8 & 0xFF) / 255.0f;
        float b = (float)(c >> 16 & 0xFF) / 255.0f;
        float l = DarknessPlus.luminance(r, g, b);
        float f = l > 0.0f ? Math.min(1.0f, lTarget / l) : 0.0f;
        return f == 1.0f ? c : 0xFF000000 | Math.round(f * r * 255.0f) | Math.round(f * g * 255.0f) << 8 | Math.round(f * b * 255.0f) << 16;
    }

    public static float luminance(float r, float g, float b) {
        return r * 0.2126f + g * 0.7152f + b * 0.0722f;
    }

    public static void updateLuminance(float tickDelta, Minecraft client, GameRenderer gameRenderer, float prevFlicker) {
        ClientLevel level = client.f_91073_;
        if (level == null) {
            return;
        }
        boolean isDarkOnLevel = DarknessPlus.isDark((Level)level);
        boolean bl = enabled = !(!isDarkOnLevel || client.f_91074_.m_21023_(MobEffects.f_19611_) || client.f_91074_.m_21023_(MobEffects.f_19592_) && client.f_91074_.m_108639_() > 0.0f || level.m_104819_() > 0);
        if (!enabled) {
            return;
        }
        float dimSkyFactor = DarknessPlus.skyFactor((Level)level);
        float ambient = level.m_104805_(1.0f);
        DimensionType dim = level.m_6042_();
        for (int skyIndex = 0; skyIndex < 16; ++skyIndex) {
            float v;
            float skyFactor = 1.0f - (float)skyIndex / 15.0f;
            skyFactor = 1.0f - skyFactor * skyFactor * skyFactor * skyFactor;
            skyFactor *= dimSkyFactor;
            float value = ((ExtrasConfig.DarknessMode)((Object)ExtrasConfig.darknessMode.get())).value;
            if (value == -1.0f) {
                throw new IllegalStateException("Darkness value can't be negative");
            }
            float min = Math.max(skyFactor * 0.05f, value);
            float rawAmbient = ambient * skyFactor;
            float minAmbient = rawAmbient * (1.0f - min) + min;
            float skyBase = LightTexture.m_234316_((DimensionType)dim, (int)skyIndex) * minAmbient;
            min = Math.max(0.35f * skyFactor, value);
            float skyRed = v = skyBase * (rawAmbient * (1.0f - min) + min);
            float skyGreen = v;
            float skyBlue = skyBase;
            if (gameRenderer.m_109131_(tickDelta) > 0.0f) {
                float skyDarkness = gameRenderer.m_109131_(tickDelta);
                skyRed = skyRed * (1.0f - skyDarkness) + skyRed * 0.7f * skyDarkness;
                skyGreen = skyGreen * (1.0f - skyDarkness) + skyGreen * 0.6f * skyDarkness;
                skyBlue = skyBlue * (1.0f - skyDarkness) + skyBlue * 0.6f * skyDarkness;
            }
            for (int blockIndex = 0; blockIndex < 16; ++blockIndex) {
                float blockFactor = 1.0f - (float)blockIndex / 15.0f;
                blockFactor = 1.0f - blockFactor * blockFactor * blockFactor * blockFactor;
                float blockBase = blockFactor * LightTexture.m_234316_((DimensionType)dim, (int)blockIndex) * (prevFlicker * 0.1f + 1.5f);
                min = 0.4f * blockFactor;
                float blockGreen = blockBase * ((blockBase * (1.0f - min) + min) * (1.0f - min) + min);
                float blockBlue = blockBase * (blockBase * blockBase * (1.0f - min) + min);
                float red = skyRed + blockBase;
                float green = skyGreen + blockGreen;
                float blue = skyBlue + blockBlue;
                float f = Math.max(skyFactor, blockFactor);
                min = 0.03f * f;
                red = red * (0.99f - min) + min;
                green = green * (0.99f - min) + min;
                blue = blue * (0.99f - min) + min;
                if (level.m_46472_() == Level.f_46430_) {
                    red = skyFactor * 0.22f + blockBase * 0.75f;
                    green = skyFactor * 0.28f + blockGreen * 0.75f;
                    blue = skyFactor * 0.25f + blockBlue * 0.75f;
                }
                if (red > 1.0f) {
                    red = 1.0f;
                }
                if (green > 1.0f) {
                    green = 1.0f;
                }
                if (blue > 1.0f) {
                    blue = 1.0f;
                }
                float gamma = ((Double)client.f_91066_.m_231927_().m_231551_()).floatValue() * f;
                float invRed = 1.0f - red;
                float invGreen = 1.0f - green;
                float invBlue = 1.0f - blue;
                invRed = 1.0f - invRed * invRed * invRed * invRed;
                invGreen = 1.0f - invGreen * invGreen * invGreen * invGreen;
                invBlue = 1.0f - invBlue * invBlue * invBlue * invBlue;
                red = red * (1.0f - gamma) + invRed * gamma;
                green = green * (1.0f - gamma) + invGreen * gamma;
                blue = blue * (1.0f - gamma) + invBlue * gamma;
                min = Math.max(0.03f * f, ((ExtrasConfig.DarknessMode)((Object)ExtrasConfig.darknessMode.get())).value);
                red = red * (0.99f - min) + min;
                green = green * (0.99f - min) + min;
                blue = blue * (0.99f - min) + min;
                if (red > 1.0f) {
                    red = 1.0f;
                }
                if (green > 1.0f) {
                    green = 1.0f;
                }
                if (blue > 1.0f) {
                    blue = 1.0f;
                }
                if (red < 0.0f) {
                    red = 0.0f;
                }
                if (green < 0.0f) {
                    green = 0.0f;
                }
                if (blue < 0.0f) {
                    blue = 0.0f;
                }
                DarknessPlus.LUMINANCE[blockIndex][skyIndex] = DarknessPlus.luminance(red, green, blue);
            }
        }
    }
}

