/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.extras.fps;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.embeddedt.embeddium.extras.ExtrasConfig;
import org.embeddedt.embeddium.extras.ExtrasTools;
import org.embeddedt.embeddium.extras.fps.FPSDisplay;

@Mod.EventBusSubscriber(modid="xenon", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class DebugOverlayEvent {
    private static final FPSDisplay DISPLAY = new FPSDisplay();
    private static final Component MSG_FPS = Component.m_237115_((String)"xenon.extras.options.displayfps.fps");
    private static final Component MSG_MIN = Component.m_237115_((String)"xenon.extras.options.displayfps.min");
    private static final Component MSG_AVG = Component.m_237115_((String)"xenon.extras.options.displayfps.avg");
    private static final Component MSG_GPU = Component.m_237115_((String)"xenon.extras.options.displayfps.gpu");
    private static final Component MSG_MEM = Component.m_237115_((String)"xenon.extras.options.displayfps.mem");
    private static final AverageQueue AVERAGE = new AverageQueue();
    private static int fps = -1;
    private static int minFPS = -1;
    private static int lastAvgFps = -1;
    private static int avgFPS = -1;
    private static int gpuPercent = -1;
    private static int memUsage = -1;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderOverlayItem(RenderGuiOverlayEvent.Pre event) {
        if (!event.getOverlay().id().m_135815_().equals("debug_text")) {
            return;
        }
        if (Minecraft.m_91087_().f_91066_.f_92065_) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiEvent.Pre event) {
        Minecraft minecraft = Minecraft.m_91087_();
        DebugOverlayEvent.renderFPSChar(minecraft, event.getGuiGraphics(), minecraft.f_91062_, event.getWindow().m_85449_());
    }

    private static void renderFPSChar(Minecraft mc, GuiGraphics graphics, Font font, double scale) {
        if (mc.f_91066_.f_92063_ || mc.f_91066_.f_92065_) {
            return;
        }
        ExtrasConfig.FPSDisplayMode mode = (ExtrasConfig.FPSDisplayMode)((Object)ExtrasConfig.fpsDisplayMode.get());
        ExtrasConfig.FPSDisplaySystemMode systemMode = (ExtrasConfig.FPSDisplaySystemMode)((Object)ExtrasConfig.fpsDisplaySystemMode.get());
        if (mode.off() && systemMode.off()) {
            return;
        }
        DISPLAY.release();
        switch (mode) {
            case SIMPLE: {
                DISPLAY.append(DebugOverlayEvent.calculateFPS$getColor(mc)).add(DebugOverlayEvent.fix(fps)).add(" ").add(MSG_FPS.getString()).add(ChatFormatting.RESET);
                break;
            }
            case FRAMETIME: 
            case ADVANCED: {
                DISPLAY.append(DebugOverlayEvent.calculateFPS$getColor(mc)).add(DebugOverlayEvent.fix(fps)).add(ChatFormatting.RESET);
                DISPLAY.append(DebugOverlayEvent.calculateMinFPS$getColor(mc)).add(MSG_MIN).add(" ").add(DebugOverlayEvent.fix(minFPS)).add(ChatFormatting.RESET);
                DISPLAY.append(DebugOverlayEvent.calculateAvgFPS$getColor(mc)).add(MSG_AVG).add(" ").add(DebugOverlayEvent.fix(avgFPS)).add(ChatFormatting.RESET);
            }
        }
        if (!DISPLAY.isEmpty()) {
            DISPLAY.split();
        }
        switch (systemMode) {
            case RAM: {
                DISPLAY.append(DebugOverlayEvent.calculateMemPercent$getColor()).add(MSG_MEM).add(" ").add(DebugOverlayEvent.fix(memUsage)).add("%").add(ChatFormatting.RESET);
                break;
            }
            case ON: {
                DISPLAY.append(DebugOverlayEvent.calculateMemPercent$getColor()).add(MSG_MEM).add(" ").add(DebugOverlayEvent.fix(memUsage)).add("%").add(ChatFormatting.RESET);
            }
        }
        if (DISPLAY.isEmpty()) {
            DISPLAY.add("FATAL ERROR");
        }
        float margin = scale > 0.0 ? (float)ExtrasConfig.fpsDisplayMarginCache / (float)scale : (float)ExtrasConfig.fpsDisplayMarginCache;
        String displayString = DISPLAY.toString();
        float maxPosX = graphics.m_280182_() - font.m_92895_(displayString);
        float posX = switch ((ExtrasConfig.FPSDisplayGravity)((Object)ExtrasConfig.fpsDisplayGravity.get())) {
            default -> throw new IncompatibleClassChangeError();
            case ExtrasConfig.FPSDisplayGravity.LEFT -> margin;
            case ExtrasConfig.FPSDisplayGravity.CENTER -> maxPosX / 2.0f;
            case ExtrasConfig.FPSDisplayGravity.RIGHT -> maxPosX - margin;
        };
        float posY = margin;
        graphics.m_280168_().m_85836_();
        if (ExtrasConfig.fpsDisplayShadowCache) {
            int n = (int)posX - 2;
            int n2 = (int)posY - 2;
            int n3 = (int)posX + font.m_92895_(displayString) + 2;
            Objects.requireNonNull(font);
            graphics.m_280509_(n, n2, n3, (int)(posY + 9.0f) + 1, -1873784752);
            graphics.m_280262_();
        }
        graphics.drawString(font, displayString, posX, posY, -1, true);
        if (mode == ExtrasConfig.FPSDisplayMode.FRAMETIME) {
            FrameTimer frameTimer = Minecraft.m_91087_().m_91293_();
            int n = (int)((float)graphics.m_280182_() / 5.5f);
            Objects.requireNonNull(font);
            DebugOverlayEvent.drawChart(graphics, frameTimer, 0, n, (int)(posY + 9.0f + 1.0f));
        }
        DISPLAY.release();
        graphics.m_280168_().m_85849_();
    }

    private static void drawChart(GuiGraphics graphics, FrameTimer timer, int x, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        int logStart = timer.m_13754_();
        int logEnd = timer.m_13761_();
        long[] along = timer.m_13764_();
        int xPos = x;
        int widthDiff = Math.max(0, along.length - width);
        int wrapped = timer.m_13762_(logStart + widthDiff);
        int guiHeight = height;
        while (wrapped != logEnd) {
            int barHeight = timer.m_13757_(along[wrapped], 30, 60) / 4;
            int heightMax = 30;
            int color = DebugOverlayEvent.getSampleColor(Mth.m_14045_((int)barHeight, (int)0, (int)heightMax), 0, heightMax / 2, heightMax);
            graphics.m_285944_(RenderType.m_286086_(), xPos, guiHeight, xPos + 1, guiHeight + barHeight, color);
            ++xPos;
            wrapped = timer.m_13762_(wrapped + 1);
        }
    }

    private static int getSampleColor(int height, int heightMin, int heightMid, int heightMax) {
        return height < heightMid ? DebugOverlayEvent.colorLerp(0x66171717, -1140870125, (float)height / (float)heightMid) : DebugOverlayEvent.colorLerp(-1140870125, -1140908238, (float)(height - heightMid) / (float)(heightMax - heightMid));
    }

    private static int colorLerp(int col1, int col2, float factor) {
        int i = col1 >> 24 & 0xFF;
        int j = col1 >> 16 & 0xFF;
        int k = col1 >> 8 & 0xFF;
        int l = col1 & 0xFF;
        int m = col2 >> 24 & 0xFF;
        int n = col2 >> 16 & 0xFF;
        int o = col2 >> 8 & 0xFF;
        int p = col2 & 0xFF;
        int q = Mth.m_14045_((int)((int)Mth.m_14179_((float)factor, (float)i, (float)m)), (int)0, (int)255);
        int r = Mth.m_14045_((int)((int)Mth.m_14179_((float)factor, (float)j, (float)n)), (int)0, (int)255);
        int s = Mth.m_14045_((int)((int)Mth.m_14179_((float)factor, (float)k, (float)o)), (int)0, (int)255);
        int t = Mth.m_14045_((int)((int)Mth.m_14179_((float)factor, (float)l, (float)p)), (int)0, (int)255);
        return q << 24 | r << 16 | s << 8 | t;
    }

    private static ChatFormatting calculateFPS$getColor(Minecraft mc) {
        fps = mc.m_260875_();
        return ExtrasTools.colorByLow(fps);
    }

    private static ChatFormatting calculateMinFPS$getColor(Minecraft mc) {
        FrameTimer timer = mc.m_91293_();
        int start = timer.m_13754_();
        int end = timer.m_13761_();
        if (end == start) {
            return ExtrasTools.colorByLow(minFPS);
        }
        int fps = mc.m_260875_();
        if (fps <= 0) {
            fps = 1;
        }
        long[] frames = timer.m_13764_();
        long maxNS = (long)(1.0 / (double)fps * 1.0E9);
        long totalNS = 0L;
        int index = Math.floorMod(end - 1, frames.length);
        while (index != start && (double)totalNS < 1.0E9) {
            long timeNs = frames[index];
            if (timeNs > maxNS) {
                maxNS = timeNs;
            }
            totalNS += timeNs;
            index = Math.floorMod(index - 1, frames.length);
        }
        minFPS = (int)(1.0 / ((double)maxNS / 1.0E9));
        return ExtrasTools.colorByLow(minFPS);
    }

    private static ChatFormatting calculateAvgFPS$getColor(Minecraft mc) {
        if (mc.m_260875_() != lastAvgFps) {
            lastAvgFps = mc.m_260875_();
            AVERAGE.push(lastAvgFps);
            avgFPS = AVERAGE.calculate();
        }
        return ExtrasTools.colorByLow(avgFPS);
    }

    private static ChatFormatting calculateMemPercent$getColor() {
        memUsage = (int)(ExtrasTools.ramUsed() * 100L / Runtime.getRuntime().maxMemory());
        return ExtrasTools.colorByPercent(memUsage);
    }

    private static String fix(int value) {
        return value == -1 ? "--" : "" + value;
    }

    public static class AverageQueue {
        private final int[] QUEUE = new int[14];
        private int used = 0;

        void push(int value) {
            if (this.used == this.QUEUE.length) {
                this.used = 0;
            }
            this.QUEUE[this.used] = value;
            ++this.used;
        }

        int calculate() {
            int times = 0;
            for (int i = 0; i < this.used; ++i) {
                times += this.QUEUE[i];
            }
            return times / this.used;
        }
    }
}

