/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.example.registry;

import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import software.bernie.example.entity.BatEntity;
import software.bernie.example.entity.BikeEntity;
import software.bernie.example.entity.CoolKidEntity;
import software.bernie.example.entity.DynamicExampleEntity;
import software.bernie.example.entity.FakeGlassEntity;
import software.bernie.example.entity.ParasiteEntity;
import software.bernie.example.entity.RaceCarEntity;

public final class EntityRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"geckolib");
    public static final RegistryObject<EntityType<BatEntity>> BAT = EntityRegistry.registerMob("bat", BatEntity::new, 0.7f, 1.3f, 0x1F1F1F, 855309);
    public static final RegistryObject<EntityType<BikeEntity>> BIKE = EntityRegistry.registerMob("bike", BikeEntity::new, 0.5f, 0.6f, 13886438, 15331829);
    public static final RegistryObject<EntityType<RaceCarEntity>> RACE_CAR = EntityRegistry.registerMob("race_car", RaceCarEntity::new, 1.5f, 1.5f, 10360342, 0x595959);
    public static final RegistryObject<EntityType<ParasiteEntity>> PARASITE = EntityRegistry.registerMob("parasite", ParasiteEntity::new, 1.5f, 1.5f, 3154457, 0xACACAC);
    public static final RegistryObject<EntityType<DynamicExampleEntity>> MUTANT_ZOMBIE = EntityRegistry.registerMob("mutant_zombie", DynamicExampleEntity::new, 0.5f, 1.9f, 3957302, 5740937);
    public static final RegistryObject<EntityType<FakeGlassEntity>> FAKE_GLASS = EntityRegistry.registerMob("fake_glass", FakeGlassEntity::new, 1.0f, 1.0f, 0xDD0000, 14221303);
    public static final RegistryObject<EntityType<CoolKidEntity>> COOL_KID = EntityRegistry.registerMob("cool_kid", CoolKidEntity::new, 0.45f, 1.0f, 6236721, 7288382);
    public static final RegistryObject<EntityType<DynamicExampleEntity>> GREMLIN = EntityRegistry.registerMob("gremlin", DynamicExampleEntity::new, 0.5f, 1.9f, 0x505050, 0x606060);

    public static <T extends Mob> RegistryObject<EntityType<T>> registerMob(String name, EntityType.EntityFactory<T> entity, float width, float height, int primaryEggColor, int secondaryEggColor) {
        RegistryObject entityType = ENTITIES.register(name, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)entity, (MobCategory)MobCategory.CREATURE).m_20699_(width, height).m_20712_(name));
        return entityType;
    }
}

