/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.defaultworldtype;

import de.melanx.defaultworldtype.DefaultWorldType;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;

public class ClientConfig {
    public static final Path CONFIG_PATH;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static ForgeConfigSpec.ConfigValue<String> worldTypeName;
    public static ForgeConfigSpec.ConfigValue<String> flatMapSettings;

    ClientConfig(ForgeConfigSpec.Builder builder) {
        builder.push("world-preset");
        worldTypeName = builder.comment("Type in the name from the world type which should be selected by default.").define("world-preset", (Object)"minecraft:normal", String.class::isInstance);
        flatMapSettings = builder.comment(new String[]{"Type in a valid generation setting for flat world type.", "Only works if world-type if 'minecraft:flat'."}).define("flat-settings", (Object)"minecraft:bedrock,2*minecraft:dirt,minecraft:grass_block;minecraft:plains", String.class::isInstance);
        builder.pop();
    }

    public static void setup() {
        try {
            Files.createDirectory(CONFIG_PATH, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            DefaultWorldType.LOGGER.debug("Config directory defaultworldtype already exists. Skip creating.");
        }
        catch (IOException e) {
            DefaultWorldType.LOGGER.error("Failed to create defaultworldtype config directory", (Throwable)e);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC, "defaultworldtype/client-config.toml");
    }

    public static ResourceKey<WorldPreset> getKey() {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256729_, (ResourceLocation)new ResourceLocation((String)worldTypeName.get()));
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
        CONFIG_PATH = Paths.get(FMLPaths.CONFIGDIR.get().toAbsolutePath().toString(), "defaultworldtype");
    }
}

