/*
 * Decompiled with CFR 0.152.
 */
package Nero.RetroHunger.EventClasses;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ChorusFruitItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="nohung", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FoodHandler {
    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        ItemStack mainHandItem = player.m_21205_();
        if (event.getHand() == InteractionHand.OFF_HAND && FoodHandler.isEdibleFood(mainHandItem)) {
            event.setCanceled(true);
            return;
        }
        if (FoodHandler.isEdibleFood(mainHandItem) || FoodHandler.canAlwaysEat(mainHandItem)) {
            if (!player.m_7500_()) {
                if (mainHandItem.m_41720_() instanceof ChorusFruitItem) {
                    event.setCanceled(true);
                    FoodHandler.chorusTeleport(player);
                } else if (FoodHandler.canAlwaysEat(mainHandItem) || !player.m_36324_().m_38721_()) {
                    FoodHandler.eatFood(player, mainHandItem);
                    event.setCanceled(true);
                }
            } else {
                event.setCanceled(true);
            }
        }
    }

    private static boolean isEdibleFood(ItemStack itemStack) {
        return itemStack.m_41614_() && itemStack.m_41720_().m_41473_() != null;
    }

    private static boolean canAlwaysEat(ItemStack itemStack) {
        FoodProperties foodProperties = itemStack.m_41720_().m_41473_();
        if (foodProperties != null) {
            return foodProperties.m_38747_();
        }
        return false;
    }

    private static void eatFood(Player player, ItemStack foodItem) {
        FoodProperties foodProperties;
        if (!player.m_9236_().f_46443_ && (foodProperties = foodItem.m_41720_().m_41473_()) != null) {
            int nutrition = foodProperties.m_38744_();
            player.m_6672_(player.m_7655_());
            ItemStack foodStack = foodItem.m_41777_();
            foodStack.m_41764_(1);
            LivingEntityUseItemEvent.Finish foodEvent = new LivingEntityUseItemEvent.Finish((LivingEntity)player, foodStack, foodProperties.m_38744_(), foodStack);
            MinecraftForge.EVENT_BUS.post((Event)foodEvent);
            player.m_5634_((float)nutrition);
            FoodHandler.applyFoodEffects(player, foodProperties);
            player.m_5810_();
            if (!player.m_150110_().f_35937_) {
                foodItem.m_41774_(1);
            }
        }
    }

    private static void applyFoodEffects(Player player, FoodProperties food) {
        List effects = food.m_38749_();
        for (Pair pair : effects) {
            if (!(player.m_9236_().f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
            player.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
        }
    }

    private static void chorusTeleport(Player player) {
        if (!player.m_9236_().f_46443_) {
            ItemStack itemStack = player.m_21205_();
            Item item = itemStack.m_41720_();
            if (!(item instanceof ChorusFruitItem)) {
                return;
            }
            ChorusFruitItem chorusFruitItem = (ChorusFruitItem)item;
            double d0 = player.m_20185_();
            double d1 = player.m_20186_();
            double d2 = player.m_20189_();
            for (int i = 0; i < 16; ++i) {
                EntityTeleportEvent.ChorusFruit event;
                double d3 = player.m_20185_() + (player.m_217043_().m_188500_() - 0.5) * 16.0;
                double d4 = Math.min((double)player.m_9236_().m_151558_(), Math.max((double)player.m_9236_().m_141937_(), player.m_20186_() + (double)(player.m_217043_().m_188503_(16) - 8)));
                double d5 = player.m_20189_() + (player.m_217043_().m_188500_() - 0.5) * 16.0;
                if (player.m_20159_()) {
                    player.m_8127_();
                }
                if (MinecraftForge.EVENT_BUS.post((Event)(event = new EntityTeleportEvent.ChorusFruit((LivingEntity)player, d3, d4, d5))) || !player.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) continue;
                player.m_9236_().m_6263_(null, d0, d1, d2, SoundEvents.f_11757_, SoundSource.PLAYERS, 1.0f, 1.0f);
                player.m_5496_(SoundEvents.f_11757_, 1.0f, 1.0f);
                player.m_36335_().m_41524_((Item)chorusFruitItem, 20);
                if (player.m_150110_().f_35937_) break;
                itemStack.m_41774_(1);
                break;
            }
        }
    }
}

