/*
 * Decompiled with CFR 0.152.
 */
package Nero.RetroHunger.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ForgeGui.class})
public class AirHudHelper {
    @Unique
    private static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("nohung", "textures/gui/icons.png");
    private int rightHeight = 39;

    @Inject(method={"renderAir"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    void onRenderAir(int width, int height, GuiGraphics guiGraphics, CallbackInfo ci) {
        Minecraft minecraft = Minecraft.m_91087_();
        Player player = (Player)minecraft.m_91288_();
        if (player == null) {
            return;
        }
        int left = width / 2 - 91;
        int top = height - this.rightHeight - 10;
        int air = player.m_20146_();
        if (player.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) || air < 300) {
            int full = Mth.m_14165_((double)((double)(air - 2) * 10.0 / 300.0));
            int partial = Mth.m_14165_((double)((double)air * 10.0 / 300.0)) - full;
            for (int i = 0; i < 10; ++i) {
                if (i < full) {
                    guiGraphics.m_280218_(GUI_ICONS_LOCATION, left + i * 8, top, 16, 18, 9, 9);
                    continue;
                }
                if (i >= full + partial) continue;
                guiGraphics.m_280218_(GUI_ICONS_LOCATION, left + i * 8, top, 25, 18, 9, 9);
            }
            this.rightHeight -= 10;
        }
        ci.cancel();
    }
}

