/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.incubator.codec.quic.SslSessionTicketKey;
import io.netty.util.internal.PlatformDependent;
import org.jetbrains.annotations.Nullable;

final class BoringSSLSessionTicketCallback {
    private volatile byte[][] sessionKeys;

    BoringSSLSessionTicketCallback() {
    }

    byte @Nullable [] findSessionTicket(byte @Nullable [] keyname) {
        byte[][] keys = this.sessionKeys;
        if (keys == null || keys.length == 0) {
            return null;
        }
        if (keyname == null) {
            return keys[0];
        }
        int i = 0;
        while (i < keys.length) {
            byte[] key = keys[i];
            if (PlatformDependent.equals((byte[])keyname, (int)0, (byte[])key, (int)1, (int)keyname.length)) {
                return key;
            }
            ++i;
        }
        return null;
    }

    void setSessionTicketKeys(SslSessionTicketKey @Nullable [] keys) {
        if (keys != null && keys.length != 0) {
            byte[][] sessionKeys = new byte[keys.length][];
            int i = 0;
            while (i < keys.length) {
                SslSessionTicketKey key = keys[i];
                byte[] binaryKey = new byte[49];
                binaryKey[0] = i == 0 ? (byte)1 : 0;
                int dstCurPos = 1;
                System.arraycopy(key.name, 0, binaryKey, dstCurPos, 16);
                System.arraycopy(key.hmacKey, 0, binaryKey, dstCurPos += 16, 16);
                System.arraycopy(key.aesKey, 0, binaryKey, dstCurPos += 16, 16);
                sessionKeys[i] = binaryKey;
                ++i;
            }
            this.sessionKeys = sessionKeys;
        } else {
            this.sessionKeys = null;
        }
    }
}

