/*
 * Decompiled with CFR 0.152.
 */
package link.e4mc;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicClientCodecBuilder;
import io.netty.incubator.codec.quic.QuicSslContext;
import io.netty.incubator.codec.quic.QuicSslContextBuilder;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import io.netty.incubator.codec.quic.QuicStreamType;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import link.e4mc.Agnos;
import link.e4mc.Config;
import link.e4mc.Mirror;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuiclimeSession {
    private static final Gson gson = new Gson();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"e4mc_minecraft");
    public State state = State.STARTING;
    private final NioEventLoopGroup group = new NioEventLoopGroup();
    private NioDatagramChannel datagramChannel;
    private QuicChannel quicChannel;

    public void startAsync() {
        Thread thread = new Thread(this::start, "e4mc_minecraft-init");
        thread.setDaemon(true);
        thread.start();
    }

    private static BrokerResponse getRelay() throws Exception {
        if (Config.INSTANCE.useBroker.value().booleanValue()) {
            HttpClient httpClient = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder(new URI(Config.INSTANCE.brokerUrl.value())).header("Accept", "application/json").build();
            LOGGER.info("req: {}", (Object)request);
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            LOGGER.info("resp: {}", response);
            if (response.statusCode() != 200) {
                throw new RuntimeException();
            }
            return (BrokerResponse)gson.fromJson(response.body(), BrokerResponse.class);
        }
        BrokerResponse resp = new BrokerResponse();
        resp.id = "custom";
        resp.host = Config.INSTANCE.relayHost.value();
        resp.port = Config.INSTANCE.relayPort.value();
        return resp;
    }

    public void start() {
        try {
            BrokerResponse relayInfo = QuiclimeSession.getRelay();
            LOGGER.info("using relay {}", (Object)relayInfo.id);
            QuicSslContext context = QuicSslContextBuilder.forClient().applicationProtocols("quiclime").build();
            ChannelHandler codec = ((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)new QuicClientCodecBuilder().sslContext(context)).sslEngineProvider(it -> context.newEngine(it.alloc(), relayInfo.host, relayInfo.port))).initialMaxStreamsBidirectional(512L)).maxIdleTimeout(10L, TimeUnit.SECONDS)).initialMaxData(0x3FFFFFFFFFFFFFFFL)).initialMaxStreamDataBidirectionalRemote(1250000L)).initialMaxStreamDataBidirectionalLocal(1250000L)).initialMaxStreamDataUnidirectional(1250000L)).build();
            ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)this.group)).channel(NioDatagramChannel.class)).handler(codec)).bind(0).addListener(datagramChannelFuture -> {
                if (!datagramChannelFuture.isSuccess()) {
                    this.state = State.UNHEALTHY;
                    if (Agnos.isClient()) {
                        Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(Mirror.translatable("text.e4mc_minecraft.error", new Object[0]));
                    }
                    throw new RuntimeException(datagramChannelFuture.cause());
                }
                this.datagramChannel = (NioDatagramChannel)((ChannelFuture)datagramChannelFuture).channel();
                QuicChannel.newBootstrap((Channel)this.datagramChannel).streamHandler((ChannelHandler)new ChannelInitializer<QuicStreamChannel>(){

                    protected void initChannel(QuicStreamChannel channel) {
                        channel.pipeline().addLast(new ChannelHandler[]{new ToQuiclimeHandler()});
                    }
                }).handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        super.exceptionCaught(ctx, cause);
                        QuiclimeSession.this.state = State.UNHEALTHY;
                        if (Agnos.isClient()) {
                            Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(Mirror.translatable("text.e4mc_minecraft.error", new Object[0]));
                        }
                    }

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        super.channelInactive(ctx);
                        QuiclimeSession.this.state = State.STOPPED;
                    }
                }).streamOption(ChannelOption.AUTO_READ, false).remoteAddress(new InetSocketAddress(InetAddress.getByName(relayInfo.host), relayInfo.port)).connect().addListener(quicChannelFuture -> {
                    if (!quicChannelFuture.isSuccess()) {
                        this.state = State.UNHEALTHY;
                        if (Agnos.isClient()) {
                            Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(Mirror.translatable("text.e4mc_minecraft.error", new Object[0]));
                        }
                        throw new RuntimeException(datagramChannelFuture.cause());
                    }
                    this.quicChannel = (QuicChannel)quicChannelFuture.get();
                    this.quicChannel.createStream(QuicStreamType.BIDIRECTIONAL, (ChannelHandler)new ChannelInitializer<QuicStreamChannel>(){

                        protected void initChannel(QuicStreamChannel ch) {
                            ch.pipeline().addLast(new ChannelHandler[]{new ControlMessageCodec(), new SimpleChannelInboundHandler<ControlMessageCodec.ControlMessage>(){

                                protected void channelRead0(ChannelHandlerContext ctx, ControlMessageCodec.ControlMessage msg) {
                                    if (msg instanceof ControlMessageCodec.DomainAssignmentCompleteMessageClientbound) {
                                        QuiclimeSession.this.state = State.STARTED;
                                        if (!Agnos.isClient()) {
                                            LOGGER.warn("e4mc running on Dedicated Server; This works, but isn't recommended as e4mc is designed for short-lived LAN servers");
                                        }
                                        String domain = ((ControlMessageCodec.DomainAssignmentCompleteMessageClientbound)msg).domain;
                                        LOGGER.info("Domain assigned: {}", (Object)domain);
                                        if (Agnos.isClient()) {
                                            Component message = Mirror.append(Mirror.translatable("text.e4mc_minecraft.domainAssigned", Mirror.withStyle(Mirror.literal(domain), it -> it.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, domain)).m_131140_(ChatFormatting.GREEN).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Mirror.translatable("chat.copy.click", new Object[0]))))), Mirror.withStyle(Mirror.translatable("text.e4mc_minecraft.clickToStop", new Object[0]), it -> it.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/e4mc stop")).m_131140_(ChatFormatting.GRAY)));
                                            Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(message);
                                        }
                                    }
                                    if (msg instanceof ControlMessageCodec.RequestMessageBroadcastMessageClientbound && Agnos.isClient()) {
                                        Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(Mirror.literal(((ControlMessageCodec.RequestMessageBroadcastMessageClientbound)msg).message));
                                    }
                                }
                            }});
                        }
                    }).addListener(it -> {
                        if (!it.isSuccess()) {
                            this.state = State.UNHEALTHY;
                            if (Agnos.isClient()) {
                                Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(Mirror.translatable("text.e4mc_minecraft.error", new Object[0]));
                            }
                            throw new RuntimeException(datagramChannelFuture.cause());
                        }
                        QuicStreamChannel streamChannel = (QuicStreamChannel)it.getNow();
                        LOGGER.info("control channel open: {}", (Object)streamChannel);
                        streamChannel.writeAndFlush(new ControlMessageCodec.RequestDomainAssignmentMessageServerbound()).addListener(ignored -> LOGGER.info("control channel write complete"));
                        this.quicChannel.closeFuture().addListener(ignored -> this.datagramChannel.close());
                    });
                });
            });
        }
        catch (Throwable e) {
            this.state = State.UNHEALTHY;
            if (Agnos.isClient()) {
                Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(Mirror.translatable("text.e4mc_minecraft.error", new Object[0]));
            }
            throw new RuntimeException(e);
        }
    }

    private static void afterCloseIfPresent(Channel channel, Consumer<Boolean> callback) {
        if (channel == null) {
            callback.accept(false);
        } else {
            channel.close().addListener(it -> callback.accept(true));
        }
    }

    public void stop() {
        this.state = State.STOPPING;
        QuiclimeSession.afterCloseIfPresent(this.quicChannel, a -> QuiclimeSession.afterCloseIfPresent((Channel)this.datagramChannel, b -> this.group.shutdownGracefully().addListener(c -> {
            this.state = State.STOPPED;
        })));
    }

    public static enum State {
        STARTING,
        STARTED,
        UNHEALTHY,
        STOPPING,
        STOPPED;

    }

    private static class BrokerResponse {
        String id;
        String host;
        int port;

        private BrokerResponse() {
        }
    }

    private static class ControlMessageCodec
    extends ByteToMessageCodec<ControlMessage> {
        protected void encode(ChannelHandlerContext ctx, ControlMessage msg, ByteBuf out) {
            byte[] json = gson.toJson((Object)msg).getBytes(StandardCharsets.UTF_8);
            out.writeByte(json.length);
            out.writeBytes(json);
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
            byte size = in.getByte(in.readerIndex());
            if (in.readableBytes() >= size + 1) {
                in.skipBytes(1);
                byte[] buf = new byte[size];
                in.readBytes(buf);
                JsonObject json = (JsonObject)gson.fromJson(new String(buf, StandardCharsets.UTF_8), JsonObject.class);
                switch (json.get("kind").getAsString()) {
                    case "domain_assignment_complete": {
                        out.add(gson.fromJson((JsonElement)json, DomainAssignmentCompleteMessageClientbound.class));
                        break;
                    }
                    case "request_message_broadcast": {
                        out.add(gson.fromJson((JsonElement)json, RequestMessageBroadcastMessageClientbound.class));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid message type!");
                    }
                }
            }
        }

        public static class DomainAssignmentCompleteMessageClientbound
        implements ControlMessage {
            String kind = "domain_assignment_complete";
            String domain;

            public DomainAssignmentCompleteMessageClientbound(String domain) {
                this.domain = domain;
            }
        }

        public static class RequestMessageBroadcastMessageClientbound
        implements ControlMessage {
            String kind = "request_message_broadcast";
            String message;

            public RequestMessageBroadcastMessageClientbound(String message) {
                this.message = message;
            }
        }

        public static interface ControlMessage {
        }

        public static class RequestDomainAssignmentMessageServerbound
        implements ControlMessage {
            String kind = "request_domain_assignment";
        }
    }

    private class ToQuiclimeHandler
    extends ChannelInboundHandlerAdapter {
        LocalChannel toMinecraft;

        private ToQuiclimeHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) {
            LOGGER.info("channel active: {}", (Object)ctx.channel());
            ChannelFuture fut = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)ctx.channel().eventLoop())).channel(LocalChannel.class)).handler((ChannelHandler)new ToMinecraftHandler((QuicStreamChannel)ctx.channel()))).option(ChannelOption.AUTO_READ, (Object)false)).connect((SocketAddress)new LocalAddress("e4mc-relay"));
            this.toMinecraft = (LocalChannel)fut.channel();
            fut.addListener(it -> {
                if (it.isSuccess()) {
                    ctx.channel().read();
                } else {
                    QuiclimeSession.this.state = State.UNHEALTHY;
                    if (Agnos.isClient()) {
                        Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(Mirror.translatable("text.e4mc_minecraft.error", new Object[0]));
                    }
                    ctx.channel().close();
                }
            });
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (this.toMinecraft.isActive()) {
                this.toMinecraft.writeAndFlush(msg).addListener(it -> {
                    if (it.isSuccess()) {
                        ctx.channel().read();
                    } else {
                        QuiclimeSession.this.state = State.UNHEALTHY;
                        if (Agnos.isClient()) {
                            Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(Mirror.translatable("text.e4mc_minecraft.error", new Object[0]));
                        }
                        ((ChannelFuture)it).channel().close();
                    }
                });
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            LOGGER.info("channel inactive(from Quiclime): {} (MC: {})", (Object)ctx.channel(), (Object)this.toMinecraft);
            if (this.toMinecraft.isActive()) {
                this.toMinecraft.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt.equals(ChannelInputShutdownReadComplete.INSTANCE)) {
                this.channelInactive(ctx);
            }
            super.userEventTriggered(ctx, evt);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            super.exceptionCaught(ctx, cause);
            QuiclimeSession.this.state = State.UNHEALTHY;
            if (Agnos.isClient()) {
                Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(Mirror.translatable("text.e4mc_minecraft.error", new Object[0]));
            }
            this.channelInactive(ctx);
        }
    }

    private class ToMinecraftHandler
    extends ChannelInboundHandlerAdapter {
        QuicStreamChannel toQuiclime;

        public ToMinecraftHandler(QuicStreamChannel channel) {
            this.toQuiclime = channel;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            ctx.read();
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            this.toQuiclime.writeAndFlush(msg).addListener(it -> {
                if (it.isSuccess()) {
                    ctx.channel().read();
                } else {
                    QuiclimeSession.this.state = State.UNHEALTHY;
                    if (Agnos.isClient()) {
                        Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(Mirror.translatable("text.e4mc_minecraft.error", new Object[0]));
                    }
                    this.toQuiclime.close();
                }
            });
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            LOGGER.info("channel inactive(from MC): {} (MC: {})", (Object)this.toQuiclime, (Object)ctx.channel());
            if (this.toQuiclime.isActive()) {
                this.toQuiclime.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            super.exceptionCaught(ctx, cause);
            QuiclimeSession.this.state = State.UNHEALTHY;
            if (Agnos.isClient()) {
                Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(Mirror.translatable("text.e4mc_minecraft.error", new Object[0]));
            }
            this.channelInactive(ctx);
        }
    }
}

