/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientScreenInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import java.util.Optional;
import java.util.function.Function;
import mod.adrenix.nostalgic.client.gui.screen.home.HomeScreen;
import mod.adrenix.nostalgic.mixin.access.MusicManagerAccess;
import mod.adrenix.nostalgic.tweak.gui.KeybindingId;
import mod.adrenix.nostalgic.util.client.KeyboardUtil;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;

public abstract class ClientKeyMapping {
    public static final KeyMapping CONFIG_KEY = new KeyMapping(Lang.Binding.OPEN_CONFIG.getString(new Object[0]), 79, Lang.TITLE.getString(new Object[0]));
    public static final KeyMapping FOG_KEY = new KeyMapping(Lang.Binding.TOGGLE_FOG.getString(new Object[0]), -1, Lang.TITLE.getString(new Object[0]));
    public static final KeyMapping NEXT_SONG_KEY = new KeyMapping(Lang.Binding.NEXT_SONG.getString(new Object[0]), -1, Lang.TITLE.getString(new Object[0]));
    public static final KeyMapping STOP_SONG_KEY = new KeyMapping(Lang.Binding.STOP_SONG.getString(new Object[0]), -1, Lang.TITLE.getString(new Object[0]));

    public static KeyMapping getFromId(KeybindingId id) {
        return switch (id) {
            default -> throw new IncompatibleClassChangeError();
            case KeybindingId.CONFIG -> CONFIG_KEY;
            case KeybindingId.FOG -> FOG_KEY;
            case KeybindingId.NEXT_SONG -> NEXT_SONG_KEY;
            case KeybindingId.STOP_SONG -> STOP_SONG_KEY;
        };
    }

    public static void register() {
        KeyMappingRegistry.register((KeyMapping)CONFIG_KEY);
        KeyMappingRegistry.register((KeyMapping)FOG_KEY);
        KeyMappingRegistry.register((KeyMapping)STOP_SONG_KEY);
        KeyMappingRegistry.register((KeyMapping)NEXT_SONG_KEY);
        ClientScreenInputEvent.KEY_PRESSED_POST.register((minecraft, screen, keyCode, scanCode, modifiers) -> {
            Function<Translation, Boolean> isBindingMatched = translation -> {
                Optional<KeyMapping> mapping = KeyboardUtil.find(translation);
                return mapping.isPresent() && mapping.get().m_90832_(keyCode, scanCode);
            };
            if (isBindingMatched.apply(Lang.Binding.OPEN_CONFIG).booleanValue()) {
                ClientKeyMapping.gotoSettingsIfPossible(minecraft);
                return EventResult.pass();
            }
            if (isBindingMatched.apply(Lang.Binding.STOP_SONG).booleanValue()) {
                ClientKeyMapping.stopCurrentSong(minecraft);
                return EventResult.pass();
            }
            if (isBindingMatched.apply(Lang.Binding.NEXT_SONG).booleanValue()) {
                ClientKeyMapping.playNewSong(minecraft);
                return EventResult.pass();
            }
            return EventResult.pass();
        });
        ClientTickEvent.CLIENT_POST.register(minecraft -> {
            while (CONFIG_KEY.m_90859_()) {
                ClientKeyMapping.gotoSettingsIfPossible(minecraft);
            }
            while (FOG_KEY.m_90859_()) {
                ClientKeyMapping.cycleRenderDistance(minecraft);
            }
            while (STOP_SONG_KEY.m_90859_()) {
                ClientKeyMapping.stopCurrentSong(minecraft);
            }
            while (NEXT_SONG_KEY.m_90859_()) {
                ClientKeyMapping.playNewSong(minecraft);
            }
        });
    }

    private static void gotoSettingsIfPossible(Minecraft minecraft) {
        if (minecraft.f_91080_ != null && ClassUtil.isNotInstanceOf(minecraft.f_91080_, TitleScreen.class)) {
            return;
        }
        minecraft.m_91152_((Screen)new HomeScreen(minecraft.f_91080_, true));
    }

    private static void cycleRenderDistance(Minecraft minecraft) {
        if (minecraft.f_91073_ != null) {
            int distance = (Integer)minecraft.f_91066_.m_231984_().m_231551_();
            if (distance >= 16) {
                minecraft.f_91066_.m_231984_().m_231514_((Object)8);
            } else if (distance >= 8) {
                minecraft.f_91066_.m_231984_().m_231514_((Object)4);
            } else if (distance >= 4) {
                minecraft.f_91066_.m_231984_().m_231514_((Object)2);
            } else if (distance >= 2) {
                minecraft.f_91066_.m_231984_().m_231514_((Object)16);
            }
            minecraft.f_91060_.m_109826_();
            minecraft.f_91066_.m_92169_();
        }
    }

    private static void stopCurrentSong(Minecraft minecraft) {
        minecraft.m_91397_().m_120186_();
    }

    private static void playNewSong(Minecraft minecraft) {
        minecraft.m_91397_().m_120186_();
        ((MusicManagerAccess)minecraft.m_91397_()).nt$setNextSongDelay(0);
    }
}

