/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.overlay;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.gui.MouseManager;
import mod.adrenix.nostalgic.client.gui.overlay.OverlayBuilder;
import mod.adrenix.nostalgic.client.gui.overlay.OverlayWidgets;
import mod.adrenix.nostalgic.client.gui.overlay.types.info.MessageOverlay;
import mod.adrenix.nostalgic.client.gui.overlay.types.info.MessageType;
import mod.adrenix.nostalgic.client.gui.screen.ParentHolder;
import mod.adrenix.nostalgic.client.gui.tooltip.TooltipManager;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankBuilder;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.LayoutBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.RelativeLayout;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetCache;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconFactory;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconTemplate;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconWidget;
import mod.adrenix.nostalgic.client.gui.widget.scrollbar.Scrollbar;
import mod.adrenix.nostalgic.client.gui.widget.scrollbar.ScrollbarBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.util.client.KeyboardUtil;
import mod.adrenix.nostalgic.util.client.animate.Animate;
import mod.adrenix.nostalgic.util.client.gui.GuiOffset;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.array.UniqueArrayList;
import mod.adrenix.nostalgic.util.common.asset.ModSprite;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.CacheValue;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import mod.adrenix.nostalgic.util.common.math.DynamicRectangle;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class Overlay
extends Screen
implements RelativeLayout,
WidgetHolder,
ParentHolder,
TooltipManager,
GuiOffset {
    protected Screen parentScreen;
    protected final OverlayBuilder builder;
    protected final OverlayWidgets widgets;
    protected final BlankWidget relativeTop;
    protected final BlankWidget relativeLeft;
    protected final Scrollbar horizontalScrollbar;
    protected final Scrollbar verticalScrollbar;
    protected DynamicRectangle<Overlay> scissor;
    protected double x;
    protected double y;
    protected int width;
    protected int height;
    protected final int padding;
    protected final int scrollbarSize;
    protected final boolean hasBorder;
    protected final boolean canDrag;
    protected boolean isMoving;

    public static OverlayBuilder create() {
        return new OverlayBuilder((Component)Lang.EMPTY.get(new Object[0]));
    }

    public static OverlayBuilder create(Component title) {
        return new OverlayBuilder(title);
    }

    public static OverlayBuilder create(Translation langKey) {
        return new OverlayBuilder((Component)langKey.get(new Object[0]));
    }

    Overlay(OverlayBuilder builder) {
        super(builder.title);
        this.builder = builder;
        this.widgets = builder.widgets;
        this.x = builder.x;
        this.y = builder.y;
        this.width = builder.width;
        this.height = builder.height;
        this.padding = builder.padding;
        this.canDrag = builder.canDrag;
        this.hasBorder = builder.hasBorder;
        this.scrollbarSize = 4;
        this.relativeTop = (BlankWidget)((BlankBuilder)((BlankBuilder)BlankWidget.create().size(0)).relativeTo(this)).build(List.of(this.widgets.all::add, this.widgets.internal::add, this.widgets.relatives::add));
        this.relativeLeft = (BlankWidget)((BlankBuilder)((BlankBuilder)BlankWidget.create().size(0)).relativeTo(this)).build(List.of(this.widgets.all::add, this.widgets.internal::add, this.widgets.relatives::add));
        this.verticalScrollbar = (Scrollbar)((ScrollbarBuilder)((ScrollbarBuilder)((ScrollbarBuilder)Scrollbar.vertical(this::getContentHeight, this::getAverageWidgetHeight).animation(Animate.easeInOutCircular(1L, TimeUnit.SECONDS)).size(this.scrollbarSize).pos(this::getScrollbarStartX, this::getInsideY)).height(this::getScrollbarHeight)).onVisibleChange(this::updateWidgets)).build(List.of(this.widgets.all::add, this.widgets.internal::add, this.widgets.scrollbars::add));
        this.horizontalScrollbar = (Scrollbar)((ScrollbarBuilder)((ScrollbarBuilder)((ScrollbarBuilder)Scrollbar.horizontal(this::getContentWidth, this::getAverageWidgetWidth).animation(Animate.easeInOutCircular(1L, TimeUnit.SECONDS)).size(this.scrollbarSize).pos(this::getInsideX, this::getScrollbarStartY)).width(this::getScrollbarWidth)).onVisibleChange(this::updateWidgets)).build(List.of(this.widgets.all::add, this.widgets.internal::add, this.widgets.scrollbars::add));
        if (this.hasBorder) {
            this.createInternalWidgets();
        }
        CollectionUtil.fromCast(this.widgets.all.stream().map(DynamicWidget::getBuilder), LayoutBuilder.class).forEach(layout -> layout.relativeTo(this));
        this.widgets.external.forEach((Consumer<DynamicWidget<?, ?>>)((Consumer<DynamicWidget>)widget -> widget.setScreen(this)));
        this.setDefaultScissor();
    }

    private void createInternalWidgets() {
        IconWidget iconWidget = (IconWidget)((IconFactory)((IconFactory)((IconFactory)IconWidget.create(this.getBuilder().icon).size(9)).posX(() -> (int)this.getX() + 7)).posY(() -> (int)this.getY() + 4)).build(List.of(this.widgets.all::add, this.widgets.internal::add));
        IconWidget closeWidget = (IconWidget)((IconFactory)((IconFactory)((IconFactory)IconTemplate.close().onPress(this::close).tabOrderGroup(-1)).posX(() -> (int)this.getEndX() - 16)).posY(() -> (int)this.getY() + 4)).build(List.of(this.widgets.all::add, this.widgets.internal::add));
        IconWidget infoWidget = (IconWidget)((IconFactory)((IconFactory)((IconFactory)IconTemplate.info().visibleIf(this::isInformative)).onPress(this::showInformation).leftOf(closeWidget, 2)).tabOrderGroup(-2)).build(List.of(this.widgets.all::add, this.widgets.internal::add));
        BlankWidget pressArea = (BlankWidget)((BlankBuilder)((BlankBuilder)((BlankBuilder)((BlankBuilder)BlankWidget.create().rightOf(iconWidget, 3)).extendWidthTo(this.isInformative() ? infoWidget : closeWidget, 3)).height(GuiUtil.textHeight() + 2)).posY(() -> (int)this.getY())).build(List.of(this.widgets.all::add, this.widgets.internal::add));
        ((TextBuilder)((TextBuilder)((TextBuilder)((TextBuilder)TextWidget.create(this.builder.title).tooltip(Lang.Overlay.DRAG_TIP, 30, 1L, TimeUnit.SECONDS)).rightOf(iconWidget, 5)).pressArea(pressArea).extendWidthTo(this.isInformative() ? infoWidget : closeWidget, 3)).onPress(this::move, Color.LEMON_YELLOW).disableUnderline().cannotFocus()).shorten().build(List.of(this.widgets.all::add, this.widgets.internal::add));
    }

    public OverlayBuilder getBuilder() {
        return this.builder;
    }

    @Override
    @Nullable
    public Screen getParentScreen() {
        return this.parentScreen;
    }

    public UniqueArrayList<DynamicWidget<?, ?>> getWidgets() {
        return this.widgets.all;
    }

    public UniqueArrayList<DynamicWidget<?, ?>> getTooltipWidgets() {
        return this.widgets.all;
    }

    public UniqueArrayList<DynamicWidget<?, ?>> getExternalWidgets() {
        return this.widgets.external;
    }

    public Stream<DynamicWidget<?, ?>> getVisibleWidgets(UniqueArrayList<DynamicWidget<?, ?>> widgets) {
        return widgets.stream().filter(DynamicWidget::isVisible);
    }

    @Override
    public void addWidget(DynamicWidget<?, ?> widget) {
        widget.setScreen(this);
        Object obj = widget.getBuilder();
        if (obj instanceof LayoutBuilder) {
            LayoutBuilder layout = (LayoutBuilder)obj;
            layout.relativeTo(this);
        }
        this.widgets.addScissoredExternal(widget);
    }

    public void addProjectedWidget(DynamicWidget<?, ?> widget) {
        this.addWidget(widget);
        this.widgets.addProjectedExternal(widget);
    }

    public void addProjectedWidgets(DynamicWidget<?, ?> ... widgets) {
        for (DynamicWidget<?, ?> widget : widgets) {
            this.addProjectedWidget(widget);
        }
    }

    @Override
    public void removeWidget(@Nullable DynamicWidget<?, ?> widget) {
        if (widget == null) {
            return;
        }
        this.widgets.removeAll(widget);
    }

    public void addListener(DynamicWidget<?, ?> widget) {
        this.widgets.listeners.add(widget);
    }

    public void removeListener(DynamicWidget<?, ?> widget) {
        this.widgets.listeners.remove(widget);
    }

    public void setCustomScissor(DynamicRectangle<Overlay> scissor) {
        this.scissor = scissor;
    }

    public int getScissorX(Overlay overlay) {
        return overlay.getInsideX() + overlay.getScissorPadding();
    }

    public int getScissorY(Overlay overlay) {
        return overlay.getInsideY() + overlay.getScissorPadding();
    }

    public int getScissorEndX(Overlay overlay) {
        return overlay.getInsideEndX() - overlay.getScissorPadding();
    }

    public int getScissorEndY(Overlay overlay) {
        return overlay.getInsideEndY() - overlay.getScissorPadding();
    }

    public void setDefaultScissor() {
        this.scissor = new DynamicRectangle<Overlay>(this::getScissorX, this::getScissorY, this::getScissorEndX, this::getScissorEndY);
    }

    public void m_7522_(@Nullable GuiEventListener focused) {
        if (focused instanceof DynamicWidget) {
            DynamicWidget dynamic = (DynamicWidget)focused;
            if (!dynamic.canFocus()) {
                return;
            }
            this.setScrollOn(dynamic);
        }
        this.widgets.all.stream().filter(DynamicWidget::m_93696_).forEach(DynamicWidget::setUnfocused);
        super.m_7522_(focused);
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.getWidgets();
    }

    public void runOnTick(Consumer<Overlay> consumer) {
        this.builder.onTickInstructions.add(consumer);
    }

    public void runOnTick(Runnable runnable) {
        this.runOnTick((Overlay overlay) -> runnable.run());
    }

    public void runOnClose(Consumer<Overlay> consumer) {
        this.builder.closingInstructions.add(consumer);
    }

    public void runOnClose(Runnable runnable) {
        this.runOnClose((Overlay overlay) -> runnable.run());
    }

    public int getScreenEndX() {
        return this.getInsideEndX() - (this.isVerticalScrollbarVisible() ? this.scrollbarSize : 0) - this.padding;
    }

    public int getScreenEndY() {
        return this.getInsideEndY() - (this.isHorizontalScrollbarVisible() ? this.scrollbarSize : 0) - this.padding;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getEndX() {
        return this.x + (double)this.width;
    }

    public double getEndY() {
        return this.y + (double)this.height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPadding() {
        return this.padding;
    }

    public int getScissorPadding() {
        return this.builder.scissorPadding;
    }

    public int getInsideX() {
        return (int)this.getX() + (this.hasBorder ? 8 : 0);
    }

    public int getInsideY() {
        return (int)this.getY() + (this.hasBorder ? 15 : 0);
    }

    public int getInsideWidth() {
        return this.width - (this.hasBorder ? 16 : 0);
    }

    public int getInsideHeight() {
        return this.height - (this.hasBorder ? 23 : 0);
    }

    public int getInsideEndX() {
        return (int)this.getX() + this.width - (this.hasBorder ? 8 : 0);
    }

    public int getInsideEndY() {
        return (int)this.getY() + this.height - (this.hasBorder ? 8 : 0);
    }

    public int getScrollOffsetX() {
        return (int)((double)this.getInsideX() - this.getScrollAmountX());
    }

    public int getScrollOffsetY() {
        return (int)((double)this.getInsideY() - this.getScrollAmountY());
    }

    @Override
    public int getRelativeX(DynamicWidget<?, ?> widget) {
        boolean isInternal = this.widgets.internal.contains(widget) && !this.widgets.relatives.contains(widget);
        return isInternal ? this.getInsideX() : this.getScrollOffsetX() + this.padding;
    }

    @Override
    public int getRelativeY(DynamicWidget<?, ?> widget) {
        boolean isInternal = this.widgets.internal.contains(widget) && !this.widgets.relatives.contains(widget);
        return isInternal ? this.getInsideY() : this.getScrollOffsetY() + this.padding;
    }

    @Override
    public int getAnchoredX(DynamicWidget<?, ?> widget) {
        return this.getInsideX() + this.padding;
    }

    @Override
    public int getAnchoredY(DynamicWidget<?, ?> widget) {
        return this.getInsideY() + this.padding;
    }

    public int getScrollbarSize() {
        return this.scrollbarSize;
    }

    private int getScrollbarStartX() {
        return this.getInsideEndX() - this.scrollbarSize;
    }

    private int getScrollbarStartY() {
        return this.getInsideEndY() - this.scrollbarSize;
    }

    private int getScrollbarWidth() {
        return this.getInsideWidth() - (this.areScrollbarsVisible() ? this.scrollbarSize : 0);
    }

    private int getScrollbarHeight() {
        return this.getInsideHeight() - (this.areScrollbarsVisible() ? this.scrollbarSize : 0);
    }

    public double getScrollAmountX() {
        return this.horizontalScrollbar.getScrollAmount();
    }

    public double getScrollAmountY() {
        return this.verticalScrollbar.getScrollAmount();
    }

    public boolean isHorizontalScrollbarVisible() {
        if (this.horizontalScrollbar == null) {
            return false;
        }
        return this.horizontalScrollbar.isVisible();
    }

    public boolean isVerticalScrollbarVisible() {
        if (this.verticalScrollbar == null) {
            return false;
        }
        return this.verticalScrollbar.isVisible();
    }

    public boolean areScrollbarsVisible() {
        return this.isHorizontalScrollbarVisible() && this.isVerticalScrollbarVisible();
    }

    public boolean isScrollbarHeld() {
        return this.verticalScrollbar.isDragging() || this.horizontalScrollbar.isDragging();
    }

    public void setScrollOn(DynamicWidget<?, ?> widget) {
        if (this.widgets.internal.contains(widget) || widget.isAnchored()) {
            return;
        }
        this.getVisibleWidgets().filter(visible -> visible.equals(widget)).findFirst().ifPresent(this::scrollTo);
    }

    private void scrollTo(DynamicWidget<?, ?> widget) {
        int relX = widget.m_252754_() - (this.getScrollOffsetX() + this.padding);
        int relY = widget.m_252907_() - (this.getScrollOffsetY() + this.padding);
        int width = widget.m_5711_();
        int height = widget.m_93694_();
        if (this.isVerticalScrollbarVisible()) {
            this.verticalScrollbar.setScrollAmount((double)relY + (double)height / 2.0 - (double)this.getInsideHeight() / 2.0);
        }
        if (this.isHorizontalScrollbarVisible()) {
            this.horizontalScrollbar.setScrollAmount((double)relX + (double)width / 2.0 - (double)this.getInsideWidth() / 2.0);
        }
    }

    public void resetScrollAmount() {
        this.verticalScrollbar.setScrollAmount(0.0);
        this.horizontalScrollbar.setScrollAmount(0.0);
    }

    private Stream<DynamicWidget<?, ?>> getScrollableWidgets() {
        return this.widgets.external.stream().filter(DynamicWidget::isNotAnchored).filter(DynamicWidget::isVisible);
    }

    private int getContentWidth() {
        int endX = this.isVerticalScrollbarVisible() ? this.getScrollbarStartX() : this.getInsideEndX();
        int x1 = this.getScrollableWidgets().mapToInt(DynamicWidget::getEndX).max().orElse(endX);
        int x0 = this.relativeLeft.m_252754_();
        int padding = this.builder.resizeForWidgets ? this.padding : this.padding * 2;
        return Math.abs(x1 - x0) + padding;
    }

    private int getContentHeight() {
        int endY = this.isHorizontalScrollbarVisible() ? this.getScrollbarStartY() : this.getInsideEndY();
        int y1 = this.getScrollableWidgets().mapToInt(DynamicWidget::getEndY).max().orElse(endY);
        int y0 = this.relativeTop.m_252907_();
        int padding = this.builder.resizeForWidgets ? this.padding : this.padding * 2;
        return Math.abs(y1 - y0) + padding;
    }

    private double getAverageWidgetWidth() {
        return (double)this.getScrollableWidgets().mapToInt(DynamicWidget::m_5711_).sum() / (double)this.getContentWidth();
    }

    private double getAverageWidgetHeight() {
        return (double)this.getScrollableWidgets().mapToInt(DynamicWidget::m_93694_).sum() / (double)this.getContentHeight();
    }

    private boolean isInformative() {
        return this.builder.infoMessage != null;
    }

    private void showInformation() {
        if (this.builder.infoMessage == null) {
            return;
        }
        MessageOverlay.create(MessageType.HELP, (Component)Lang.Button.HELP.get(new Object[0]), this.builder.infoMessage).setResizePercentage(0.65).build().open();
    }

    public boolean borderless() {
        return !this.hasBorder;
    }

    public void move() {
        if (!this.canDrag) {
            return;
        }
        this.isMoving = true;
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        if (this.parentScreen != null) {
            Minecraft.m_91087_().f_91080_ = this.parentScreen;
            this.parentScreen.m_6574_(minecraft, width, height);
        }
        Minecraft.m_91087_().f_91080_ = this;
        super.m_6574_(minecraft, width, height);
        if (this.builder.aboveOrBelow != null) {
            this.close();
        }
        this.updateSize();
        this.center();
        this.resetScrollAmount();
    }

    public void m_86600_() {
        this.widgets.all.forEach((Consumer<DynamicWidget<?, ?>>)((Consumer<DynamicWidget>)DynamicWidget::tick));
        this.builder.onTickInstructions.forEach(consumer -> consumer.accept(this));
    }

    public Optional<DynamicWidget<?, ?>> getWidgetAtPoint(double mouseX, double mouseY) {
        return this.getVisibleWidgets(this.widgets.external).filter(widget -> widget.m_5953_(mouseX, mouseY)).findFirst();
    }

    public boolean isWidgetOutside(DynamicWidget<?, ?> widget) {
        boolean isOutsideX = widget.getEndX() < this.getInsideX() || widget.m_252754_() > this.getInsideEndX();
        boolean isOutsideY = widget.getEndY() < this.getInsideY() || widget.m_252907_() > this.getInsideEndY();
        return isOutsideX || isOutsideY;
    }

    public boolean isWidgetInside(DynamicWidget<?, ?> widget) {
        return !this.isWidgetOutside(widget);
    }

    public boolean isMouseInsideWindow(double mouseX, double mouseY) {
        double dx = this.isHorizontalScrollbarVisible() ? (double)this.scrollbarSize : 0.0;
        double dy = this.isVerticalScrollbarVisible() ? (double)this.scrollbarSize : 0.0;
        double overlayX = this.getInsideX();
        double overlayY = this.getInsideY();
        double overlayW = (double)this.getInsideWidth() + dx;
        double overlayH = (double)this.getInsideHeight() + dy;
        return MathUtil.isWithinBox(mouseX, mouseY, overlayX, overlayY, overlayW, overlayH);
    }

    private boolean isEventListened(Predicate<DynamicWidget<?, ?>> predicate) {
        if (!this.widgets.listeners.isEmpty() && CollectionUtil.test(this.widgets.listeners, predicate)) {
            return true;
        }
        return CollectionUtil.test(this.getVisibleWidgets(), predicate);
    }

    public boolean isValidClick(double mouseX, double mouseY, int button) {
        return button == 0 && MathUtil.isWithinBox(mouseX, mouseY, this.x, this.y, this.width, this.height);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        NostalgicTweaks.LOGGER.debug(String.format("mouseX: %s | mouseY: %s", mouseX, mouseY));
        boolean isWidgetClicked = this.isEventListened(widget -> {
            if (this.widgets.external.contains(widget) && !this.isMouseInsideWindow(mouseX, mouseY)) {
                return false;
            }
            boolean isClicked = widget.m_6375_(mouseX, mouseY, button);
            if (isClicked) {
                this.widgets.all.stream().filter(DynamicWidget::m_93696_).forEach(DynamicWidget::setUnfocused);
                widget.setClickFocus();
            }
            return isClicked;
        });
        if (isWidgetClicked) {
            return true;
        }
        if (this.isMouseInsideWindow(mouseX, mouseY)) {
            if (this.isValidClick(mouseX, mouseY, button)) {
                this.widgets.external.stream().filter(DynamicWidget::m_93696_).forEach(DynamicWidget::setUnfocused);
            }
        } else if (this.borderless()) {
            this.close();
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.isMoving) {
            this.offScreenCheck();
            this.isMoving = false;
        }
        if (this.isEventListened(widget -> widget.m_6348_(mouseX, mouseY, button))) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isMoving) {
            this.x += dragX;
            this.y += dragY;
            this.syncBeforeRender();
            return true;
        }
        if (this.isEventListened(widget -> widget.m_7979_(mouseX, mouseY, button, dragX, dragY))) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double deltaY) {
        boolean isWidgetScrolled = this.getWidgetAtPoint(mouseX, mouseY).stream().anyMatch(widget -> widget.m_6050_(mouseX, mouseY, deltaY));
        if (isWidgetScrolled) {
            return true;
        }
        if (this.isEventListened(widget -> widget.m_6050_(mouseX, mouseY, deltaY))) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, deltaY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (Screen.m_96638_() && Screen.m_96637_() && keyCode == 68) {
            NostalgicTweaks.LOGGER.setDebug();
            return true;
        }
        if (Screen.m_96638_() && Screen.m_96637_() && keyCode == 84) {
            Minecraft.m_91087_().m_91391_();
            return true;
        }
        if (Screen.m_96638_() && Screen.m_96637_() && keyCode == 70) {
            GuiUtil.toggleShowFps();
            return true;
        }
        boolean isCustomPressed = this.builder.onKeyPressInstructions.stream().anyMatch(instructions -> instructions.test(this, keyCode, scanCode, modifiers));
        if (isCustomPressed) {
            return true;
        }
        if (this.m_7222_() != null && this.m_7222_().m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.isEventListened(widget -> widget.m_7933_(keyCode, scanCode, modifiers))) {
            return true;
        }
        if (KeyboardUtil.isEsc(keyCode)) {
            this.close();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.isEventListened(widget -> widget.m_7920_(keyCode, scanCode, modifiers))) {
            return true;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.m_7222_() != null) {
            return this.m_7222_().m_5534_(codePoint, modifiers);
        }
        if (this.isEventListened(widget -> widget.m_5534_(codePoint, modifiers))) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public void resizeIfNeeded() {
        boolean isHeightChanged;
        boolean isWidthChanged;
        if (this.isMoving) {
            return;
        }
        boolean isResized = false;
        if ((this.builder.resizeWidthForWidgets || this.builder.resizeForWidgets) && (isWidthChanged = this.widgets.external.stream().map(DynamicWidget::getCache).map(WidgetCache::getWidth).anyMatch(CacheValue::isExpired))) {
            isResized = true;
        }
        if ((this.builder.resizeHeightForWidgets || this.builder.resizeForWidgets) && (isHeightChanged = this.widgets.external.stream().map(DynamicWidget::getCache).map(WidgetCache::getHeight).anyMatch(CacheValue::isExpired))) {
            isResized = true;
        }
        if (isResized) {
            this.syncBeforeRender();
            this.updateSize();
        }
    }

    private void setPositionFromSuppliers() {
        if (this.builder.xFunction != null && (double)this.builder.xFunction.applyAsInt(this) != this.x) {
            this.x = this.builder.xFunction.applyAsInt(this);
        }
        if (this.builder.yFunction != null && (double)this.builder.yFunction.applyAsInt(this) != this.y) {
            this.y = this.builder.yFunction.applyAsInt(this);
        }
        if (this.builder.aboveOrBelow != null) {
            boolean isAboveOrBelow;
            if (this.builder.xFunction == null) {
                this.x = this.builder.aboveOrBelow.m_252754_();
            }
            int scaledHeight = GuiUtil.getGuiHeight();
            int aboveDiff = 0;
            int belowDiff = 0;
            int yAbove = this.builder.aboveOrBelow.m_252907_() - this.builder.aboveOrBelowMargin - this.getHeight();
            int yBelow = this.builder.aboveOrBelow.m_252907_() + this.builder.aboveOrBelow.m_93694_() + this.builder.aboveOrBelowMargin;
            if (yAbove <= 0) {
                aboveDiff = Math.abs(yAbove - 1);
                yAbove = 1;
            }
            if (yBelow + this.height >= scaledHeight - 1) {
                belowDiff = Math.abs(yBelow + this.height - (scaledHeight - 1));
            }
            boolean bl = isAboveOrBelow = !this.builder.onlyAbove && !this.builder.onlyBelow;
            this.y = isAboveOrBelow ? (this.builder.aboveOrBelow.m_252907_() > scaledHeight / 2 ? (double)yAbove : (double)yBelow) : (this.builder.onlyAbove ? (double)yAbove : (double)yBelow);
            if (this.y == (double)yAbove && isAboveOrBelow) {
                this.height -= aboveDiff;
            } else if (this.y == (double)yBelow && isAboveOrBelow) {
                this.height -= belowDiff;
            }
        }
    }

    @Override
    public float getZOffset() {
        Screen parent = this.parentScreen;
        float zOffset = 20.0f;
        int index = 1;
        while (parent instanceof Overlay) {
            Overlay overlay = (Overlay)parent;
            ++index;
            zOffset += 15.0f;
            parent = overlay.parentScreen;
        }
        return zOffset * (float)index;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.setPositionFromSuppliers();
        if (this.parentScreen != null) {
            Minecraft.m_91087_().f_91080_ = this.parentScreen;
            MouseManager.setPosition(-1, -1);
            this.parentScreen.m_88315_(graphics, -1, -1, partialTick);
            MouseManager.setPosition(mouseX, mouseY);
            Minecraft.m_91087_().f_91080_ = this;
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85850_().m_252922_().translate(0.0f, 0.0f, this.getZOffset());
        this.m_280273_(graphics);
        if (this.builder.firstRenderer != null) {
            this.builder.firstRenderer.accept(this, graphics, mouseX, mouseY, partialTick);
        }
        this.renderBorder(graphics);
        this.renderWidgets(graphics, mouseX, mouseY, partialTick);
        if (this.builder.lastRenderer != null) {
            this.builder.lastRenderer.accept(this, graphics, mouseX, mouseY, partialTick);
        }
        graphics.m_280168_().m_85849_();
    }

    public void m_280273_(GuiGraphics graphics) {
        int winWidth = GuiUtil.getGuiWidth();
        int winHeight = GuiUtil.getGuiHeight();
        this.resizeIfNeeded();
        RenderUtil.beginBatching();
        if (this.builder.hasShadow) {
            RenderUtil.fill(graphics, 0.0f, 0.0f, (float)winWidth, (float)winHeight, this.builder.shadowColor);
        }
        int startX = this.getInsideX();
        int startY = this.getInsideY();
        int endX = this.getInsideEndX();
        int endY = this.getInsideEndY();
        if (this.builder.backgroundGradient == null) {
            RenderUtil.fill(graphics, (float)startX, (float)startY, (float)endX, (float)endY, this.builder.backgroundColor);
        } else {
            RenderUtil.gradient(this.builder.backgroundGradient, graphics, startX, startY, endX, endY);
        }
        if (this.borderless() && !this.builder.outlineColor.isEmpty()) {
            int x = startX - 1;
            int y = startY - 1;
            int w = endX - startX + 2;
            int h = endY - startY + 2;
            RenderUtil.outline(graphics, (float)x, (float)y, (float)w, (float)h, this.builder.outlineColor);
        }
        RenderUtil.endBatching();
    }

    private void renderBorder(GuiGraphics graphics) {
        if (this.borderless()) {
            return;
        }
        RenderUtil.blitSprite(ModSprite.OVERLAY, graphics, (int)this.x, (int)this.y, this.width, this.height);
    }

    private void syncBeforeRender() {
        DynamicWidget.syncWithoutCache(this.widgets.external);
        DynamicWidget.syncWithoutCache(this.widgets.relatives);
        DynamicWidget.syncWithoutCache(this.widgets.scrollbars);
    }

    private void renderWidgets(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        boolean isHorizontalChanged;
        if (this.verticalScrollbar.isInvisible() && this.verticalScrollbar.getScrollAmount() > 0.0) {
            this.verticalScrollbar.setScrollAmount(0.0);
        }
        if (this.horizontalScrollbar.isInvisible() && this.horizontalScrollbar.getScrollAmount() > 0.0) {
            this.horizontalScrollbar.setScrollAmount(0.0);
        }
        boolean isVerticalVisible = this.verticalScrollbar.isVisible();
        boolean isHorizontalVisible = this.horizontalScrollbar.isVisible();
        this.syncBeforeRender();
        boolean isVerticalChanged = isVerticalVisible != this.verticalScrollbar.isVisible();
        boolean bl = isHorizontalChanged = isHorizontalVisible != this.horizontalScrollbar.isVisible();
        if (isVerticalChanged || isHorizontalChanged) {
            this.syncBeforeRender();
        }
        RenderUtil.pushZoneScissor(this.scissor.getRectangle(this));
        DynamicWidget.renderWithoutSync(this.widgets.scissored, graphics, mouseX, mouseY, partialTick);
        RenderUtil.popScissor();
        DynamicWidget.renderWithoutSync(this.widgets.projected, graphics, mouseX, mouseY, partialTick);
        DynamicWidget.render(this.widgets.internal, graphics, mouseX, mouseY, partialTick);
        DynamicWidget.applyCache(this.widgets.external);
        DynamicWidget.applyCache(this.widgets.relatives);
        if (this.areScrollbarsVisible()) {
            int sX = this.getInsideEndX() - this.scrollbarSize;
            int sY = this.getInsideEndY() - this.scrollbarSize;
            int eX = this.getInsideEndX();
            int eY = this.getInsideEndY();
            RenderUtil.fill(graphics, (float)sX, (float)sY, (float)eX, (float)eY, Color.SONIC_SILVER);
        }
    }

    private void center() {
        if (this.builder.xFunction != null || this.builder.yFunction != null) {
            return;
        }
        double lastX = this.x;
        double lastY = this.y;
        this.x = MathUtil.center(this.width, GuiUtil.getGuiWidth());
        this.y = MathUtil.center(this.height, GuiUtil.getGuiHeight());
        if (this.x != lastX || this.y != lastY) {
            this.updateWidgets();
        }
    }

    private void resizeWithPercentage() {
        if (!this.builder.resizeUsingPercentage) {
            return;
        }
        if (this.builder.resizeWidthPercentage.getAsDouble() > 0.0) {
            this.width = (int)Math.round((double)this.parentScreen.f_96543_ * this.builder.resizeWidthPercentage.getAsDouble());
        }
        if (this.builder.resizeHeightPercentage.getAsDouble() > 0.0) {
            this.height = (int)Math.round((double)this.parentScreen.f_96544_ * this.builder.resizeHeightPercentage.getAsDouble());
        }
        if (this.builder.resizeWidthMaximum > 0) {
            this.width = Math.min(this.width, this.builder.resizeWidthMaximum);
        }
        if (this.builder.resizeHeightMaximum > 0) {
            this.height = Math.min(this.height, this.builder.resizeHeightMaximum);
        }
        if (this.width < this.builder.minWidth) {
            this.width = this.builder.minWidth;
        }
        if (this.height < this.builder.minHeight) {
            this.height = this.builder.minHeight;
        }
        this.x = MathUtil.center(this.width, GuiUtil.getGuiWidth());
        this.y = MathUtil.center(this.height, GuiUtil.getGuiHeight());
    }

    private void offScreenCheck() {
        double lastX = this.x;
        double lastY = this.y;
        int lastWidth = this.width;
        int lastHeight = this.height;
        if (this.x + (double)this.width <= 0.0) {
            this.x = 0.0;
        }
        if (this.x > (double)GuiUtil.getGuiWidth() - 5.0) {
            this.x = (double)GuiUtil.getGuiWidth() - 26.0;
        }
        if (this.y < 0.0) {
            this.y = 0.0;
        }
        if (this.y > (double)GuiUtil.getGuiHeight()) {
            this.y = (double)GuiUtil.getGuiHeight() - 16.0;
        }
        if ((double)this.width > (double)GuiUtil.getGuiWidth() - 10.0) {
            this.width = GuiUtil.getGuiWidth() - 10;
        }
        if ((double)this.height > (double)GuiUtil.getGuiHeight() - 10.0) {
            this.height = GuiUtil.getGuiHeight() - 10;
        }
        if (this.x != lastX || this.y != lastY || this.width != lastWidth || this.height != lastHeight) {
            this.center();
        }
    }

    private int getInsideWidgetWidth() {
        int minX = this.getVisibleWidgets(this.widgets.external).mapToInt(DynamicWidget::m_252754_).min().orElse(this.getInsideX());
        int maxX = this.getVisibleWidgets(this.widgets.external).mapToInt(DynamicWidget::getEndX).max().orElse(this.getInsideX() + 20);
        int margin = Math.abs(this.relativeLeft.m_252754_() - minX) * 2;
        return Math.abs(maxX - minX) + margin;
    }

    private int getInsideWidgetHeight() {
        int minY = this.getVisibleWidgets(this.widgets.external).mapToInt(DynamicWidget::m_252907_).min().orElse(this.getInsideY());
        int maxY = this.getVisibleWidgets(this.widgets.external).mapToInt(DynamicWidget::getEndY).max().orElse(this.getInsideY() + 20);
        int margin = Math.abs(this.relativeTop.m_252907_() - minY) * 2;
        return Math.abs(maxY - minY) + margin;
    }

    public void resizeToFitContent() {
        this.setWidth(0);
        this.setHeight(0);
        this.updateWidgets();
        this.resizeForOverflow();
    }

    public void resizeForOverflow() {
        int width = this.getInsideWidgetWidth();
        int height = this.getInsideWidgetHeight();
        if (this.width != width) {
            this.setWidth(width + this.padding + (this.hasBorder ? 16 : 0) + this.scrollbarSize);
        }
        if (this.height != height) {
            this.setHeight(height + this.padding + (this.hasBorder ? 23 : 0) + this.scrollbarSize);
        }
        if (this.width != width || this.height != height) {
            this.offScreenCheck();
            this.center();
        }
    }

    public void shrinkWidthToFitContent() {
        this.updateWidgets();
        int width = this.getInsideWidgetWidth() + this.padding;
        if (width < this.width) {
            this.setWidth(width - this.padding + (this.hasBorder ? 16 : this.padding * 2) + (this.hasBorder ? this.scrollbarSize : 0));
            this.offScreenCheck();
            this.center();
        }
    }

    public void shrinkHeightToFitContent() {
        this.updateWidgets();
        int height = this.getInsideWidgetHeight() + this.padding;
        if (height < this.height) {
            this.setHeight(height - this.padding + (this.hasBorder ? 23 : this.padding * 2) + (this.hasBorder ? this.scrollbarSize : 0));
            this.offScreenCheck();
            this.center();
        }
    }

    public void updateWidgets() {
        DynamicWidget.syncWithoutCache(this.widgets.relatives);
        DynamicWidget.syncWithoutCache(this.widgets.external);
    }

    public void updateSize() {
        this.verticalScrollbar.setScrollAmount(0.0);
        this.horizontalScrollbar.setSmoothScrollAmount(0.0);
        this.resizeWithPercentage();
        if (this.builder.resizeForWidgets) {
            this.resizeToFitContent();
        } else if (this.builder.resizeWidthForWidgets) {
            this.shrinkWidthToFitContent();
        } else if (this.builder.resizeHeightForWidgets) {
            this.shrinkHeightToFitContent();
        }
        this.updateWidgets();
        this.offScreenCheck();
        if (this.builder.onResize != null) {
            this.builder.onResize.accept(this);
        }
    }

    public Overlay open() {
        if (Minecraft.m_91087_().f_91080_ == this) {
            return this;
        }
        this.parentScreen = Minecraft.m_91087_().f_91080_;
        Minecraft.m_91087_().m_91152_((Screen)this);
        this.updateSize();
        return this;
    }

    public void close() {
        this.getBuilder().closingInstructions.forEach(consumer -> consumer.accept(this));
        if (this.builder.onClose != null) {
            this.builder.onClose.run();
        }
        Minecraft.m_91087_().f_91080_ = this.parentScreen;
    }

    public void openOrClose() {
        if (Minecraft.m_91087_().f_91080_ == this) {
            this.close();
        } else {
            this.open();
        }
    }
}

