/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.overlay;

import java.util.LinkedHashSet;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.ToIntFunction;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.overlay.OverlayKeyboard;
import mod.adrenix.nostalgic.client.gui.overlay.OverlayRenderer;
import mod.adrenix.nostalgic.client.gui.overlay.OverlayWidgets;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.color.Gradient;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class OverlayBuilder {
    @Nullable
    final Screen parent;
    final Component title;
    final OverlayWidgets widgets;
    final LinkedHashSet<Consumer<Overlay>> closingInstructions;
    final LinkedHashSet<Consumer<Overlay>> onTickInstructions;
    final LinkedHashSet<OverlayKeyboard> onKeyPressInstructions;
    boolean canDrag = true;
    boolean hasBorder = true;
    boolean hasShadow = true;
    boolean resizeForWidgets = false;
    boolean resizeUsingPercentage = false;
    boolean resizeWidthForWidgets = false;
    boolean resizeHeightForWidgets = false;
    DoubleSupplier resizeWidthPercentage = () -> 0.0;
    DoubleSupplier resizeHeightPercentage = () -> 0.0;
    double x = -1.0;
    double y = -1.0;
    int width = 100;
    int height = 100;
    int minWidth = 50;
    int minHeight = 50;
    int padding = 0;
    int scissorPadding = 0;
    int aboveOrBelowMargin = 0;
    int resizeWidthMaximum = 0;
    int resizeHeightMaximum = 0;
    @Nullable
    OverlayRenderer firstRenderer = null;
    @Nullable
    OverlayRenderer lastRenderer = null;
    @Nullable
    Gradient backgroundGradient = null;
    Color outlineColor = Color.TRANSPARENT;
    Color backgroundColor = new Color(0, 0, 0, 198);
    Color shadowColor = new Color(0, 0, 0, 165);
    boolean onlyAbove = false;
    boolean onlyBelow = false;
    @Nullable
    LayoutElement aboveOrBelow = null;
    @Nullable
    ToIntFunction<Overlay> xFunction = null;
    @Nullable
    ToIntFunction<Overlay> yFunction = null;
    @Nullable
    Consumer<Overlay> onResize = null;
    @Nullable
    Component infoMessage = null;
    @Nullable
    Runnable onClose = null;
    TextureIcon icon = Icons.GENERIC_OVERLAY;

    OverlayBuilder(Component title) {
        this.widgets = new OverlayWidgets();
        this.closingInstructions = new LinkedHashSet();
        this.onTickInstructions = new LinkedHashSet();
        this.onKeyPressInstructions = new LinkedHashSet();
        this.parent = GuiUtil.getScreen().orElse(null);
        this.title = title;
    }

    public OverlayBuilder addWidget(DynamicWidget<?, ?> widget) {
        this.widgets.addScissoredExternal(widget);
        return this;
    }

    public OverlayBuilder addListener(DynamicWidget<?, ?> widget) {
        this.widgets.listeners.add(widget);
        return this;
    }

    public OverlayBuilder pos(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public OverlayBuilder pos(ToIntFunction<Overlay> xFunction, ToIntFunction<Overlay> yFunction) {
        this.xFunction = xFunction;
        this.yFunction = yFunction;
        this.canDrag = false;
        return this;
    }

    public OverlayBuilder pos(IntSupplier xSupplier, IntSupplier ySupplier) {
        return this.pos((Overlay overlay) -> xSupplier.getAsInt(), (Overlay overlay) -> ySupplier.getAsInt());
    }

    public OverlayBuilder setX(int x) {
        this.x = x;
        return this;
    }

    public OverlayBuilder setX(ToIntFunction<Overlay> xFunction) {
        this.xFunction = xFunction;
        this.canDrag = false;
        return this;
    }

    public OverlayBuilder setX(IntSupplier xSupplier) {
        return this.setX((Overlay overlay) -> xSupplier.getAsInt());
    }

    public OverlayBuilder setY(int y) {
        this.y = y;
        return this;
    }

    public OverlayBuilder setY(ToIntFunction<Overlay> yFunction) {
        this.yFunction = yFunction;
        this.canDrag = false;
        return this;
    }

    public OverlayBuilder setY(IntSupplier ySupplier) {
        return this.setY((Overlay overlay) -> ySupplier.getAsInt());
    }

    public OverlayBuilder size(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public OverlayBuilder size(int size) {
        this.width = size;
        this.height = size;
        return this;
    }

    public OverlayBuilder minSize(int minWidth, int minHeight) {
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        return this;
    }

    public OverlayBuilder minSize(int minSize) {
        this.minWidth = minSize;
        this.minHeight = minSize;
        return this;
    }

    public OverlayBuilder setWidth(int width) {
        this.width = width;
        return this;
    }

    public OverlayBuilder minWidth(int minWidth) {
        this.minWidth = minWidth;
        return this;
    }

    public OverlayBuilder setHeight(int height) {
        this.height = height;
        return this;
    }

    public OverlayBuilder minHeight(int minHeight) {
        this.minHeight = minHeight;
        return this;
    }

    public OverlayBuilder onResize(Consumer<Overlay> consumer) {
        this.onResize = consumer;
        return this;
    }

    public OverlayBuilder onResize(Runnable runnable) {
        this.onResize = overlay -> runnable.run();
        return this;
    }

    public OverlayBuilder resizeUsingPercentage(DoubleSupplier percentage, int maximum) {
        this.resizeUsingPercentage = true;
        this.resizeWidthPercentage = () -> Mth.m_14008_((double)percentage.getAsDouble(), (double)0.1, (double)1.0);
        this.resizeHeightPercentage = () -> Mth.m_14008_((double)percentage.getAsDouble(), (double)0.1, (double)1.0);
        this.resizeWidthMaximum = maximum;
        this.resizeHeightMaximum = maximum;
        return this;
    }

    public OverlayBuilder resizeUsingPercentage(double percentage, int maximum) {
        return this.resizeUsingPercentage(() -> percentage, maximum);
    }

    public OverlayBuilder resizeUsingPercentage(DoubleSupplier percentage) {
        return this.resizeUsingPercentage(percentage, 0);
    }

    public OverlayBuilder resizeUsingPercentage(double percentage) {
        return this.resizeUsingPercentage(percentage, 0);
    }

    public OverlayBuilder resizeWidthUsingPercentage(DoubleSupplier percentage, int maximum) {
        this.resizeUsingPercentage = true;
        this.resizeWidthPercentage = () -> Mth.m_14008_((double)percentage.getAsDouble(), (double)0.0, (double)1.0);
        this.resizeWidthMaximum = maximum;
        return this;
    }

    public OverlayBuilder resizeWidthUsingPercentage(double percentage, int maximum) {
        return this.resizeWidthUsingPercentage(() -> percentage, maximum);
    }

    public OverlayBuilder resizeWidthUsingPercentage(double percentage) {
        return this.resizeWidthUsingPercentage(percentage, 0);
    }

    public OverlayBuilder resizeHeightUsingPercentage(DoubleSupplier percentage, int maximum) {
        this.resizeUsingPercentage = true;
        this.resizeHeightPercentage = () -> Mth.m_14008_((double)percentage.getAsDouble(), (double)0.0, (double)1.0);
        this.resizeHeightMaximum = maximum;
        return this;
    }

    public OverlayBuilder resizeHeightUsingPercentage(double percentage, int maximum) {
        return this.resizeHeightUsingPercentage(() -> percentage, maximum);
    }

    public OverlayBuilder resizeHeightUsingPercentage(double percentage) {
        return this.resizeHeightUsingPercentage(percentage, 0);
    }

    public OverlayBuilder padding(int padding) {
        this.padding = padding;
        return this;
    }

    public OverlayBuilder scissorPadding(int padding) {
        this.scissorPadding = padding;
        return this;
    }

    public OverlayBuilder resizeForWidgets() {
        this.resizeForWidgets = true;
        return this;
    }

    public OverlayBuilder resizeWidthForWidgets() {
        this.resizeWidthForWidgets = true;
        return this;
    }

    public OverlayBuilder resizeHeightForWidgets() {
        this.resizeHeightForWidgets = true;
        return this;
    }

    public OverlayBuilder unmovable() {
        this.canDrag = false;
        return this;
    }

    public OverlayBuilder borderless() {
        this.hasBorder = false;
        return this;
    }

    public OverlayBuilder shadowless() {
        this.hasShadow = false;
        return this;
    }

    public OverlayBuilder above(LayoutElement element, int margin) {
        this.onlyAbove = true;
        return this.aboveOrBelow(element, margin);
    }

    public OverlayBuilder aboveOrBelow(LayoutElement element, int margin) {
        this.aboveOrBelow = element;
        this.aboveOrBelowMargin = margin;
        return this;
    }

    public OverlayBuilder below(LayoutElement element, int margin) {
        this.onlyBelow = true;
        return this.aboveOrBelow(element, margin);
    }

    public OverlayBuilder gradientBackground(Gradient gradient) {
        this.backgroundGradient = gradient;
        return this;
    }

    public OverlayBuilder preRenderer(OverlayRenderer renderer) {
        this.firstRenderer = renderer;
        return this;
    }

    public OverlayBuilder postRenderer(OverlayRenderer renderer) {
        this.lastRenderer = renderer;
        return this;
    }

    public OverlayBuilder outlineColor(Color color) {
        this.outlineColor = color;
        return this;
    }

    public OverlayBuilder backgroundColor(Color color) {
        this.backgroundColor = color;
        return this;
    }

    public OverlayBuilder shadowColor(Color color) {
        this.shadowColor = color;
        return this;
    }

    public OverlayBuilder icon(TextureIcon icon) {
        this.icon = icon;
        return this;
    }

    public OverlayBuilder icon(Block block) {
        this.icon = TextureIcon.fromBlock(block);
        return this;
    }

    public OverlayBuilder icon(Item item) {
        this.icon = TextureIcon.fromItem(item);
        return this;
    }

    public OverlayBuilder onClose(Runnable runnable) {
        this.onClose = runnable;
        return this;
    }

    public OverlayBuilder infoMessage(Component tooltip) {
        this.infoMessage = tooltip;
        return this;
    }

    public OverlayBuilder infoMessage(Translation langKey) {
        return this.infoMessage((Component)langKey.get(new Object[0]));
    }

    public OverlayBuilder runOnKeyPressed(OverlayKeyboard keyPressed) {
        this.onKeyPressInstructions.add(keyPressed);
        return this;
    }

    public OverlayBuilder runOnTick(Consumer<Overlay> consumer) {
        this.onTickInstructions.add(consumer);
        return this;
    }

    public OverlayBuilder runOnTick(Runnable runnable) {
        return this.runOnTick((Overlay overlay) -> runnable.run());
    }

    public OverlayBuilder runOnClose(Consumer<Overlay> consumer) {
        this.closingInstructions.add(consumer);
        return this;
    }

    public OverlayBuilder runOnClose(Runnable runnable) {
        return this.runOnClose((Overlay overlay) -> runnable.run());
    }

    public Overlay build() {
        Overlay overlay = new Overlay(this);
        if (this.xFunction != null) {
            this.x = this.xFunction.applyAsInt(overlay);
        }
        if (this.yFunction != null) {
            this.y = this.yFunction.applyAsInt(overlay);
        }
        if (this.x < 0.0) {
            overlay.setX(MathUtil.center(this.width, GuiUtil.getScreenWidth()));
        }
        if (this.y < 0.0) {
            overlay.setY(MathUtil.center(this.height, GuiUtil.getScreenHeight()));
        }
        return overlay;
    }
}

