/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.overlay.types.color;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import mod.adrenix.nostalgic.client.gui.overlay.types.color.ColorPicker;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconFactory;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconTemplate;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.array.ArrayUtil;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.function.ForEachWithPrevious;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import mod.adrenix.nostalgic.util.common.text.TextUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

class PickerPalette {
    static final int SIZE = 7;
    static final ArrayList<Color> RECENT = new ArrayList(7);
    static final ArrayList<Color> RANDOM = new ArrayList(7);
    private final ColorPicker picker;

    PickerPalette(ColorPicker picker) {
        this.picker = picker;
        if (RANDOM.isEmpty()) {
            for (int i = 0; i < 7; ++i) {
                RANDOM.add(Color.getRandomColor());
            }
        } else {
            for (int i = 0; i < 7; ++i) {
                RANDOM.get(i).set(Color.getRandomColor());
            }
        }
    }

    void build() {
        this.createStandardPalette();
        this.createRandomPalette();
        this.createRecentPalette();
    }

    private void createStandardPalette() {
        int padding = 2;
        ButtonWidget darkRed = (ButtonWidget)this.getPaletteColorFactory(ChatFormatting.DARK_RED).build();
        ButtonWidget red = (ButtonWidget)((ButtonBuilder)this.getPaletteColorFactory(ChatFormatting.RED).rightOf(darkRed, padding)).build();
        ButtonWidget gold = (ButtonWidget)((ButtonBuilder)this.getPaletteColorFactory(ChatFormatting.GOLD).rightOf(red, padding)).build();
        ButtonWidget yellow = (ButtonWidget)((ButtonBuilder)this.getPaletteColorFactory(ChatFormatting.YELLOW).rightOf(gold, padding)).build();
        ButtonWidget darkGreen = (ButtonWidget)((ButtonBuilder)this.getPaletteColorFactory(ChatFormatting.DARK_GREEN).rightOf(yellow, padding)).build();
        ButtonWidget green = (ButtonWidget)((ButtonBuilder)this.getPaletteColorFactory(ChatFormatting.GREEN).rightOf(darkGreen, padding)).build();
        ButtonWidget aqua = (ButtonWidget)((ButtonBuilder)this.getPaletteColorFactory(ChatFormatting.AQUA).rightOf(green, padding)).build();
        ButtonWidget darkAqua = (ButtonWidget)((ButtonBuilder)this.getPaletteColorFactory(ChatFormatting.DARK_AQUA).rightOf(aqua, padding)).build();
        ButtonWidget darkBlue = (ButtonWidget)((ButtonBuilder)this.getPaletteColorFactory(ChatFormatting.DARK_BLUE).below(darkRed, padding)).build();
        ButtonWidget blue = (ButtonWidget)((ButtonBuilder)this.getPaletteColorFactory(ChatFormatting.BLUE).rightOf(darkBlue, padding)).build();
        ButtonWidget lightPurple = (ButtonWidget)((ButtonBuilder)this.getPaletteColorFactory(ChatFormatting.LIGHT_PURPLE).rightOf(blue, padding)).build();
        ButtonWidget darkPurple = (ButtonWidget)((ButtonBuilder)this.getPaletteColorFactory(ChatFormatting.DARK_PURPLE).rightOf(lightPurple, padding)).build();
        ButtonWidget white = (ButtonWidget)((ButtonBuilder)this.getPaletteColorFactory(ChatFormatting.WHITE).rightOf(darkPurple, padding)).build();
        ButtonWidget gray = (ButtonWidget)((ButtonBuilder)this.getPaletteColorFactory(ChatFormatting.GRAY).rightOf(white, padding)).build();
        ButtonWidget darkGray = (ButtonWidget)((ButtonBuilder)this.getPaletteColorFactory(ChatFormatting.DARK_GRAY).rightOf(gray, padding)).build();
        ButtonWidget black = (ButtonWidget)((ButtonBuilder)this.getPaletteColorFactory(ChatFormatting.BLACK).rightOf(darkGray, padding)).build();
        this.picker.group.palette.addWidget(darkRed);
        this.picker.group.palette.addWidget(red);
        this.picker.group.palette.addWidget(gold);
        this.picker.group.palette.addWidget(yellow);
        this.picker.group.palette.addWidget(darkGreen);
        this.picker.group.palette.addWidget(green);
        this.picker.group.palette.addWidget(aqua);
        this.picker.group.palette.addWidget(darkAqua);
        this.picker.group.palette.addWidget(darkBlue);
        this.picker.group.palette.addWidget(blue);
        this.picker.group.palette.addWidget(lightPurple);
        this.picker.group.palette.addWidget(darkPurple);
        this.picker.group.palette.addWidget(white);
        this.picker.group.palette.addWidget(gray);
        this.picker.group.palette.addWidget(darkGray);
        this.picker.group.palette.addWidget(black);
    }

    private void alignRandom(ButtonWidget prev, ButtonWidget next) {
        ((ButtonBuilder)next.getBuilder()).rightOf(prev, 2);
    }

    private void alignRecent(ButtonWidget prev, ButtonWidget next) {
        ((ButtonBuilder)next.getBuilder()).rightOf(prev, 2);
    }

    private void createRandomPalette() {
        ArrayList<ButtonWidget> random = new ArrayList<ButtonWidget>(7);
        for (int i = 0; i < 7; ++i) {
            random.add(this.getColorSquareFactory(RANDOM.get(i)).build(this.picker.group.random::addWidget));
        }
        ForEachWithPrevious.create(random).forEach(this::alignRandom).run();
        ((IconFactory)((IconFactory)((IconFactory)((IconFactory)IconTemplate.close().onPress(() -> {
            for (int i = 0; i < 7; ++i) {
                RANDOM.get(i).set(Color.getRandomColor());
            }
        }).tooltip(Lang.Picker.RANDOMIZE, 500L, TimeUnit.MILLISECONDS)).hideTooltipAfter(3L, TimeUnit.SECONDS)).alignVerticalTo((DynamicWidget)CollectionUtil.last(random).orElse(null), 1)).rightOf((DynamicWidget)CollectionUtil.last(random).orElse(null), 3)).build(this.picker.group.random::addWidget);
    }

    private void createRecentPalette() {
        ArrayList<ButtonWidget> recent = new ArrayList<ButtonWidget>(7);
        for (int i = 0; i < 7; ++i) {
            recent.add(this.getRecentColorFactory(ArrayUtil.get(RECENT, i).orElse(Color.TRANSPARENT)).build(this.picker.group.recent::addWidget));
        }
        ForEachWithPrevious.create(recent).forEach(this::alignRecent).run();
        ((IconFactory)((IconFactory)((IconFactory)((IconFactory)IconTemplate.close().onPress(() -> {
            for (int i = 0; i < 7; ++i) {
                RECENT.forEach(color -> color.set(Color.TRANSPARENT));
            }
        }).tooltip(Lang.Picker.CLEAR, 500L, TimeUnit.MILLISECONDS)).hideTooltipAfter(4L, TimeUnit.SECONDS)).alignVerticalTo((DynamicWidget)CollectionUtil.last(recent).orElse(null), 1)).rightOf((DynamicWidget)CollectionUtil.last(recent).orElse(null), 3)).build(this.picker.group.recent::addWidget);
    }

    private ButtonBuilder getColorSquareFactory(Color color) {
        int size = 11;
        return (ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().size(size)).onPress(() -> this.picker.color.set(color))).renderer((button, graphics, mouseX, mouseY, partialTick) -> {
            int border;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85837_((double)button.m_252754_(), (double)button.m_252907_(), 0.0);
            boolean isHighlighted = button.m_93696_() || this.picker.color.equals(color);
            int n = border = isHighlighted ? Color.LIGHT_BLUE.get() : Color.GRAY.get();
            if (button.m_5953_(mouseX, mouseY)) {
                border = Color.WHITE.get();
            }
            RenderUtil.beginBatching();
            RenderUtil.outline(graphics, 0.0f, 0.0f, (float)size, (float)size, border);
            if (color.isTransparent()) {
                int width = size - 2;
                int height = size - 2;
                for (int row = 1; row <= height; ++row) {
                    Color primary = MathUtil.isOdd(row) ? Color.GRAY : Color.WHITE;
                    Color secondary = MathUtil.isOdd(row) ? Color.WHITE : Color.GRAY;
                    for (int i = 1; i <= width; ++i) {
                        RenderUtil.fill(graphics, (float)i, (float)row, (float)(i + 1), (float)(row + 1), MathUtil.isEven(i) ? primary : secondary);
                    }
                }
            }
            RenderUtil.fill(graphics, 1.0f, 1.0f, (float)(size - 1), (float)(size - 1), color.get());
            RenderUtil.endBatching();
            graphics.m_280168_().m_85849_();
        });
    }

    private ButtonBuilder getPaletteColorFactory(ChatFormatting formatting) {
        return (ButtonBuilder)this.getColorSquareFactory(Color.fromFormatting(formatting)).tooltip((Component)Component.m_237113_((String)TextUtil.toTitleCase(formatting.m_126666_())), 750L, TimeUnit.MILLISECONDS);
    }

    private ButtonBuilder getRecentColorFactory(Color color) {
        return (ButtonBuilder)this.getColorSquareFactory(color).onPress(() -> {
            if (color.isPresent()) {
                this.picker.color.set(color);
            }
        });
    }
}

