/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.overlay.types.color;

import mod.adrenix.nostalgic.client.gui.overlay.types.color.ColorPicker;
import mod.adrenix.nostalgic.client.gui.widget.slider.color.ColorSlider;
import mod.adrenix.nostalgic.client.gui.widget.slider.color.ColorSliderBuilder;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.color.ColorElement;

class PickerSlider {
    private final ColorPicker picker;
    private final Color color;
    final ColorSlider hue;
    final ColorSlider saturation;
    final ColorSlider brightness;
    final ColorSlider opacity;
    final ColorSlider red;
    final ColorSlider green;
    final ColorSlider blue;

    PickerSlider(ColorPicker picker) {
        this.picker = picker;
        this.color = picker.color;
        this.hue = this.createSlider(ColorElement.HUE);
        this.saturation = this.createSlider(ColorElement.SATURATION);
        this.brightness = this.createSlider(ColorElement.BRIGHTNESS);
        this.red = this.createSlider(ColorElement.RED);
        this.green = this.createSlider(ColorElement.GREEN);
        this.blue = this.createSlider(ColorElement.BLUE);
        this.opacity = this.createSlider(ColorElement.ALPHA);
    }

    void build() {
        ((ColorSliderBuilder)((ColorSliderBuilder)this.hue.getBuilder()).below(this.picker.text.hue, 3)).width(this.picker.group.hsb::getInsideWidth);
        ((ColorSliderBuilder)((ColorSliderBuilder)this.saturation.getBuilder()).below(this.picker.text.saturation, 3)).width(this.picker.group.hsb::getInsideWidth);
        ((ColorSliderBuilder)((ColorSliderBuilder)this.brightness.getBuilder()).below(this.picker.text.brightness, 3)).width(this.picker.group.hsb::getInsideWidth);
        ((ColorSliderBuilder)((ColorSliderBuilder)this.red.getBuilder()).below(this.picker.text.red, 3)).width(this.picker.group.rgb::getInsideWidth);
        ((ColorSliderBuilder)((ColorSliderBuilder)this.green.getBuilder()).below(this.picker.text.green, 3)).width(this.picker.group.rgb::getInsideWidth);
        ((ColorSliderBuilder)((ColorSliderBuilder)this.blue.getBuilder()).below(this.picker.text.blue, 3)).width(this.picker.group.rgb::getInsideWidth);
        ((ColorSliderBuilder)((ColorSliderBuilder)this.opacity.getBuilder()).below(this.picker.text.opacity, 3)).width(this.picker.group.alpha::getInsideWidth);
        this.opacity.setActive(this.picker.transparent);
    }

    private ColorSlider createSlider(ColorElement element) {
        return (ColorSlider)((ColorSliderBuilder)ColorSlider.create(this.color, element).scrollWithoutFocus()).build();
    }
}

