/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.overlay.types.color;

import mod.adrenix.nostalgic.client.gui.overlay.types.color.ColorPicker;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

class PickerText {
    private final ColorPicker picker;
    private final Color color;
    final TextWidget hue;
    final TextWidget saturation;
    final TextWidget brightness;
    final TextWidget red;
    final TextWidget green;
    final TextWidget blue;
    final TextWidget opacity;
    final TextWidget sample;

    PickerText(ColorPicker picker) {
        this.picker = picker;
        this.color = picker.color;
        this.hue = (TextWidget)TextWidget.create(this::getHue).build();
        this.saturation = (TextWidget)TextWidget.create(this::getSaturation).build();
        this.brightness = (TextWidget)TextWidget.create(this::getBrightness).build();
        this.red = (TextWidget)TextWidget.create(this::getRed).build();
        this.green = (TextWidget)TextWidget.create(this::getGreen).build();
        this.blue = (TextWidget)TextWidget.create(this::getBlue).build();
        this.opacity = (TextWidget)TextWidget.create(this::getOpacity).build();
        this.sample = (TextWidget)TextWidget.create((Component)Component.m_237113_((String)"The quick brown fox jumps over the lazy dog.")).build();
    }

    void build() {
        ((TextBuilder)((TextBuilder)this.hue.getBuilder()).width(this.picker.group.hsb::getInsideWidth)).color(() -> new Color(Color.HSBtoRGB(this.color.getHue(), 1.0f, 1.0f)).get()).centerAligned();
        ((TextBuilder)((TextBuilder)((TextBuilder)this.saturation.getBuilder()).below(this.picker.slider.hue, 3)).width(this.picker.group.hsb::getInsideWidth)).centerAligned();
        ((TextBuilder)((TextBuilder)((TextBuilder)this.brightness.getBuilder()).below(this.picker.slider.saturation, 3)).width(this.picker.group.hsb::getInsideWidth)).centerAligned();
        ((TextBuilder)((TextBuilder)this.red.getBuilder()).width(this.picker.group.rgb::getInsideWidth)).color(Color.fromFormatting(ChatFormatting.RED)).centerAligned();
        ((TextBuilder)((TextBuilder)((TextBuilder)this.green.getBuilder()).below(this.picker.slider.red, 3)).width(this.picker.group.rgb::getInsideWidth)).color(Color.fromFormatting(ChatFormatting.GREEN)).centerAligned();
        ((TextBuilder)((TextBuilder)((TextBuilder)this.blue.getBuilder()).below(this.picker.slider.green, 3)).width(this.picker.group.rgb::getInsideWidth)).color(Color.fromFormatting(ChatFormatting.BLUE)).centerAligned();
        ((TextBuilder)((TextBuilder)this.opacity.getBuilder()).color(this.picker.transparent ? Color.WHITE::get : Color.GRAY::get).width(this.picker.group.alpha::getInsideWidth)).centerAligned();
        ((TextBuilder)((TextBuilder)((TextBuilder)this.sample.getBuilder()).color(this.color).width(this.picker.group.sample::getInsideWidth)).height(this.picker.group.alpha::getInsideHeight)).background(new Color(() -> this.color.darken(0.5).get())).centerAligned();
    }

    private Component getHue() {
        return Component.m_237113_((String)String.format("Hue: %s", Math.round(this.color.getHue() * 360.0f)));
    }

    private Component getSaturation() {
        return Component.m_237113_((String)String.format("Saturation: %s%%", Math.round(this.color.getSaturation() * 100.0f)));
    }

    private Component getBrightness() {
        return Component.m_237113_((String)String.format("Brightness: %s%%", Math.round(this.color.getBrightness() * 100.0f)));
    }

    private Component getRed() {
        return Component.m_237113_((String)String.format("Red: %s", this.color.getRed()));
    }

    private Component getGreen() {
        return Component.m_237113_((String)String.format("Green: %s", this.color.getGreen()));
    }

    private Component getBlue() {
        return Component.m_237113_((String)String.format("Blue: %s", this.color.getBlue()));
    }

    private Component getOpacity() {
        String alpha = Lang.Picker.OPACITY.getString(new Object[0]) + ": %s%%";
        return Component.m_237113_((String)String.format(alpha, Math.round(this.color.getFloatAlpha() * 100.0f)));
    }
}

