/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.overlay.types.info;

import java.util.LinkedHashSet;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.overlay.OverlayBuilder;
import mod.adrenix.nostalgic.client.gui.overlay.types.info.MessageType;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.color.Gradient;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import net.minecraft.network.chat.Component;

public class MessageOverlay {
    private final LinkedHashSet<ButtonBuilder> buttons = new LinkedHashSet();
    private final OverlayBuilder builder;
    private final MessageType messageType;
    private final Component message;
    private int padding = 2;
    private int maxSize = 200;
    private double resizePercentage = 0.35;
    private boolean centerAlign = true;

    public static MessageOverlay create(MessageType messageType, Translation header, Translation message) {
        return new MessageOverlay(messageType, (Component)header.get(new Object[0]), (Component)message.get(new Object[0]));
    }

    public static MessageOverlay create(MessageType messageType, Component header, Component message) {
        return new MessageOverlay(messageType, header, message);
    }

    private MessageOverlay(MessageType messageType, Component header, Component message) {
        this.builder = Overlay.create(header);
        this.message = message;
        this.messageType = messageType;
    }

    public OverlayBuilder getBuilder() {
        return this.builder;
    }

    public MessageOverlay setPadding(int padding) {
        this.padding = padding;
        return this;
    }

    public MessageOverlay setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public MessageOverlay setResizePercentage(double percentage) {
        this.resizePercentage = percentage;
        return this;
    }

    public MessageOverlay alignLeft() {
        this.centerAlign = false;
        return this;
    }

    public MessageOverlay addButton(ButtonBuilder factory) {
        this.buttons.add(factory);
        return this;
    }

    public Overlay build() {
        TextureIcon icon = switch (this.messageType) {
            default -> throw new IncompatibleClassChangeError();
            case MessageType.SUCCESS -> Icons.SMALL_CHECK;
            case MessageType.SEARCH -> Icons.SMALL_SEARCH;
            case MessageType.ERROR -> Icons.SMALL_RED_X;
            case MessageType.HELP -> Icons.SMALL_INFO;
            case MessageType.WARNING -> Icons.SMALL_WARNING;
            case MessageType.RED_WARNING -> Icons.SMALL_RED_WARNING;
        };
        Gradient background = switch (this.messageType) {
            default -> throw new IncompatibleClassChangeError();
            case MessageType.SUCCESS -> Gradient.vertical(new Color(3298866, 220), new Color(0x212D21, 220));
            case MessageType.SEARCH -> Gradient.vertical(new Color(3371143, 220), new Color(1255987, 220));
            case MessageType.HELP -> Gradient.vertical(new Color(2770802, 220), new Color(1847372, 220));
            case MessageType.ERROR -> Gradient.vertical(new Color(6499115, 220), new Color(0x281111, 220));
            case MessageType.WARNING -> Gradient.vertical(new Color(7819277, 220), new Color(2957061, 220));
            case MessageType.RED_WARNING -> Gradient.vertical(new Color(6499114, 220), new Color(0x281111, 220));
        };
        Overlay overlay = this.builder.icon(icon).gradientBackground(background).resizeUsingPercentage(this.resizePercentage, this.maxSize).resizeHeightForWidgets().padding(this.padding).build();
        TextWidget message = ((TextBuilder)TextWidget.create(this.message).extendWidthToScreenEnd(0)).build(overlay::addWidget);
        if (this.centerAlign) {
            ((TextBuilder)message.getBuilder()).centerAligned();
        }
        DynamicWidget last = null;
        for (ButtonBuilder factory : this.buttons) {
            last = ((ButtonBuilder)((ButtonBuilder)factory.below(message, this.padding)).extendWidthToScreenEnd(0)).build(overlay::addWidget);
        }
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.OKAY).icon(Icons.GREEN_CHECK)).below(last != null ? last : message, this.padding)).extendWidthToScreenEnd(0)).onPress(overlay::close)).build(overlay::addWidget);
        return overlay;
    }
}

