/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.overlay.types.state;

import java.util.function.Supplier;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonTemplate;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.client.gui.widget.group.Group;
import mod.adrenix.nostalgic.client.gui.widget.group.GroupBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorWidget;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.function.BooleanConsumer;
import mod.adrenix.nostalgic.util.common.function.BooleanSupplier;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class SwitchGroup {
    private final WidgetHolder parent;
    private final Supplier<Component> header;
    private final Supplier<Component> description;
    private final ButtonWidget toggle;
    @Nullable
    private Group group;

    private SwitchGroup(WidgetHolder parent, Supplier<Component> header, Supplier<Component> description, BooleanSupplier getter, BooleanConsumer setter) {
        this.parent = parent;
        this.description = description;
        this.header = header;
        this.toggle = (ButtonWidget)ButtonTemplate.toggle(getter, setter).build();
    }

    public static SwitchGroup create(WidgetHolder parent, Supplier<Component> header, Supplier<Component> description, BooleanSupplier getter, BooleanConsumer setter) {
        return new SwitchGroup(parent, header, description, getter, setter);
    }

    public static SwitchGroup create(WidgetHolder parent, Component header, Component description, BooleanSupplier getter, BooleanConsumer setter) {
        return new SwitchGroup(parent, () -> header, () -> description, getter, setter);
    }

    public static SwitchGroup create(WidgetHolder parent, Translation header, Translation description, BooleanSupplier getter, BooleanConsumer setter) {
        return new SwitchGroup(parent, () -> header.get(new Object[0]), () -> description.get(new Object[0]), getter, setter);
    }

    public Widgets getWidgets() {
        TextWidget header = (TextWidget)this.getHeader().build();
        TextWidget description = (TextWidget)((TextBuilder)this.getDescription().below(header, 4)).build();
        return new Widgets(this.toggle, header, description);
    }

    public ButtonWidget getToggle() {
        return this.toggle;
    }

    public TextBuilder getHeader() {
        return (TextBuilder)TextWidget.create(this.header).rightOf(this.toggle, 4);
    }

    public TextBuilder getDescription() {
        return (TextBuilder)TextWidget.create(this.description).rightOf(this.toggle, 4);
    }

    public Group getInstance() {
        if (this.group != null) {
            return this.group;
        }
        TextWidget header = (TextWidget)((TextBuilder)this.getHeader().extendWidthToScreenEnd(0)).build();
        TextWidget description = (TextWidget)((TextBuilder)((TextBuilder)this.getDescription().below(header, 4)).extendWidthToScreenEnd(0)).build();
        SeparatorWidget separator = (SeparatorWidget)((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(Color.WHITE).below(description, 4)).height(1)).extendWidthToScreenEnd(6)).build();
        this.group = (Group)((GroupBuilder)Group.create(this.parent).extendWidthToScreenEnd(0)).addWidget(this.toggle).addWidget(header).addWidget(description).addWidget(separator).build();
        return this.group;
    }

    public record Widgets(ButtonWidget toggle, TextWidget header, TextWidget description) {
        public void subscribeTo(WidgetHolder parent) {
            parent.addWidgets(this.toggle, this.header, this.description);
        }
    }
}

