/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.overlay.types.state;

import java.util.List;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.overlay.types.state.SwitchGroup;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.group.GroupBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorWidget;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.function.ForEachWithPrevious;
import net.minecraft.client.gui.layouts.LayoutElement;

public class SwitchOverlay {
    private final Overlay overlay;

    private SwitchOverlay(LayoutElement aboveOrBelow) {
        this.overlay = Overlay.create().setWidth(200).padding(6).aboveOrBelow(aboveOrBelow, 3).backgroundColor(new Color(0, 0, 0, 235)).shadowColor(new Color(0, 0, 0, 80)).scissorPadding(3).resizeHeightForWidgets().unmovable().borderless().build();
    }

    public static SwitchOverlay create(LayoutElement aboveOrBelow) {
        return new SwitchOverlay(aboveOrBelow);
    }

    public void open() {
        this.overlay.open();
    }

    public Overlay get() {
        return this.overlay;
    }

    public void setGroups(List<SwitchGroup> groups) {
        ForEachWithPrevious.create(groups).applyToFirst(this::subscribe).applyToLast(this::debar).forEach(this::setup).run();
    }

    private void subscribe(SwitchGroup group) {
        this.overlay.addWidget(group.getInstance());
    }

    private void debar(SwitchGroup group) {
        group.getInstance().getWidgetStream().filter(widget -> widget instanceof SeparatorWidget).findFirst().ifPresent(separator -> group.getInstance().removeWidget((DynamicWidget<?, ?>)separator));
    }

    private void setup(SwitchGroup previous, SwitchGroup next) {
        this.subscribe(next);
        ((GroupBuilder)next.getInstance().getBuilder()).below(previous.getInstance(), 4);
    }
}

