/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen;

import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.gui.screen.ParentHolder;
import mod.adrenix.nostalgic.client.gui.tooltip.TooltipManager;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.util.client.KeyboardUtil;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.array.UniqueArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;

public interface DynamicScreen<T extends Screen>
extends WidgetHolder,
ParentHolder,
TooltipManager {
    public T self();

    public UniqueArrayList<DynamicWidget<?, ?>> getWidgets();

    default public UniqueArrayList<DynamicWidget<?, ?>> getTooltipWidgets() {
        return this.getWidgets();
    }

    @Override
    default public void addWidget(DynamicWidget<?, ?> widget) {
        ((UniqueArrayList)this.getWidgets()).add(widget);
        widget.setScreen((Screen)this.self());
    }

    default public boolean isKeyPressed(int keyCode, int scanCode, int modifiers) {
        GuiEventListener focused = this.self().m_7222_();
        if (focused != null && focused.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        for (DynamicWidget widget : this.getWidgets()) {
            if (!widget.m_7933_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        if (KeyboardUtil.isEsc(keyCode) && this.self().m_6913_()) {
            this.self().m_7379_();
            return true;
        }
        if (Screen.m_96638_() && Screen.m_96637_() && keyCode == 68) {
            NostalgicTweaks.LOGGER.setDebug();
            return true;
        }
        if (Screen.m_96638_() && Screen.m_96637_() && keyCode == 84) {
            Minecraft.m_91087_().m_91391_();
            return true;
        }
        if (Screen.m_96638_() && Screen.m_96637_() && keyCode == 70) {
            GuiUtil.toggleShowFps();
            return true;
        }
        return false;
    }

    default public boolean isMouseClicked(double mouseX, double mouseY, int button) {
        NostalgicTweaks.LOGGER.debug(String.format("mouseX: %s | mouseY: %s", mouseX, mouseY));
        boolean isWidgetClicked = false;
        for (DynamicWidget widget : this.getWidgets()) {
            if (!widget.m_6375_(mouseX, mouseY, button)) continue;
            this.getWidgets().stream().filter(DynamicWidget::m_93696_).forEach(DynamicWidget::setUnfocused);
            widget.setClickFocus();
            this.self().m_7522_((GuiEventListener)widget);
            if (button == 0) {
                this.self().m_7897_(true);
            }
            isWidgetClicked = true;
            break;
        }
        if (isWidgetClicked) {
            return true;
        }
        this.getWidgets().stream().filter(DynamicWidget::m_93696_).forEach(DynamicWidget::setUnfocused);
        return false;
    }

    default public boolean isMouseReleased(double mouseX, double mouseY, int button) {
        return this.getWidgets().stream().anyMatch(widget -> widget.m_6348_(mouseX, mouseY, button));
    }

    default public boolean isMouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.getWidgets().stream().anyMatch(widget -> widget.m_7979_(mouseX, mouseY, button, dragX, dragY));
    }

    default public void focusFirst() {
        this.getWidgets().stream().filter(DynamicWidget::canFocus).findFirst().ifPresent(arg_0 -> this.self().m_7522_(arg_0));
    }

    default public void setDynamicFocus(@Nullable GuiEventListener focused) {
        DynamicWidget dynamic;
        if (focused instanceof DynamicWidget && !(dynamic = (DynamicWidget)focused).canFocus()) {
            return;
        }
        this.getWidgets().stream().filter(DynamicWidget::m_93696_).forEach(DynamicWidget::setUnfocused);
    }
}

