/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import mod.adrenix.nostalgic.client.AfterConfigSave;
import mod.adrenix.nostalgic.client.gui.screen.EnhancedScreen;
import mod.adrenix.nostalgic.client.gui.screen.config.ConfigWidgets;
import mod.adrenix.nostalgic.client.gui.screen.config.ScreenCache;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.list.GroupRow;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.list.RowProvider;
import mod.adrenix.nostalgic.client.gui.screen.home.Panorama;
import mod.adrenix.nostalgic.client.gui.tooltip.Tooltip;
import mod.adrenix.nostalgic.config.cache.ConfigCache;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.tweak.container.Category;
import mod.adrenix.nostalgic.tweak.container.Container;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.tweak.factory.TweakMeta;
import mod.adrenix.nostalgic.tweak.factory.TweakPool;
import mod.adrenix.nostalgic.util.client.KeyboardUtil;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import mod.adrenix.nostalgic.util.common.timer.FlagTimer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class ConfigScreen
extends EnhancedScreen<ConfigScreen, ConfigWidgets> {
    static final ScreenCache SCREEN_CACHE = new ScreenCache();
    private ConfigWidgets configWidgets;
    private Container category = Category.MOD;
    private final FlagTimer timer = FlagTimer.create(1L, TimeUnit.SECONDS).build();
    private boolean visible = true;
    private boolean initialized = false;

    public ConfigScreen(@Nullable Screen parentScreen) {
        super(ConfigWidgets::new, parentScreen, (Component)Lang.Home.TITLE.get(new Object[0]));
        if (this.minecraft.f_91073_ != null) {
            TweakPool.setAllFail();
        }
        TweakPool.setAllCacheModes();
    }

    @Override
    protected void m_7856_() {
        if (this.initialized && !SCREEN_CACHE.isPushed()) {
            SCREEN_CACHE.push(this);
        }
        super.m_7856_();
        this.initialized = true;
        if (((Boolean)ModTweak.PERSISTENT_CONFIG_SCREEN.get()).booleanValue()) {
            SCREEN_CACHE.pop(this);
        } else {
            SCREEN_CACHE.reset();
        }
        if (ConfigScreen.SCREEN_CACHE.rowProvider.equals((Object)RowProvider.DEFAULT)) {
            this.configWidgets.getTabs().stream().filter(tab -> tab.getCategory().equals(ConfigScreen.SCREEN_CACHE.category)).findFirst().ifPresent(arg_0 -> ((ConfigScreen)this).m_7522_(arg_0));
        }
    }

    @Override
    public ConfigScreen self() {
        return this;
    }

    @Override
    public ConfigWidgets getWidgetManager() {
        return this.configWidgets;
    }

    @Override
    public void setWidgetManager(ConfigWidgets configWidgets) {
        this.configWidgets = configWidgets;
    }

    public Container getCategory() {
        return this.category;
    }

    public void setCategory(Container category) {
        this.category = category;
        this.configWidgets.stopGivingSearchResults();
        this.configWidgets.getRowList().resetScrollAmount();
        this.configWidgets.populateRowList();
    }

    public void jumpTo(Container container) {
        Optional<GroupRow> groupRow;
        if (RowProvider.DEFAULT.isProviding()) {
            if (container.isCategory()) {
                if (this.category == container) {
                    this.configWidgets.getRowList().setSmoothScrollAmount(0.0);
                }
                return;
            }
        } else {
            this.setCategory(container.getCategory());
            RowProvider.DEFAULT.use();
        }
        if ((groupRow = CollectionUtil.fromCast(this.configWidgets.getRowList().getRows(), GroupRow.class).filter(row -> row.getContainer().equals(container)).findFirst()).isPresent()) {
            groupRow.get().jumpToMe();
            return;
        }
        container.getGroupSetFromCategory().forEach(this::jumpFromGroup);
    }

    private void jumpFromGroup(Container container) {
        CollectionUtil.fromCast(this.configWidgets.getRowList().getRows(), GroupRow.class).filter(row -> row.getContainer().equals(container)).findFirst().ifPresent(GroupRow::jumpToMe);
    }

    public boolean getTimerState() {
        return this.timer.getFlag();
    }

    @Override
    public void m_6574_(Minecraft minecraft, int width, int height) {
        SCREEN_CACHE.push(this);
        super.m_6574_(minecraft, width, height);
        SCREEN_CACHE.pop(this);
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (KeyboardUtil.isGoingLeft(keyCode)) {
            this.configWidgets.selectTabLeft();
            return true;
        }
        if (KeyboardUtil.isGoingRight(keyCode)) {
            this.configWidgets.selectTabRight();
            return true;
        }
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (Screen.m_96637_() && keyCode == 81) {
            this.configWidgets.getFavorite().onPress();
        }
        if (Screen.m_96637_() && keyCode == 65) {
            this.configWidgets.getAll().onPress();
        }
        if (Screen.m_96637_() && keyCode == 83) {
            this.saveConfig();
        }
        if (Screen.m_96637_() && keyCode == 76) {
            this.visible = !this.visible;
        }
        return false;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.visible) {
            return false;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double deltaY) {
        if (!this.visible) {
            return false;
        }
        int width = this.f_96543_;
        int height = this.configWidgets.getTabLeft().getEndY();
        if (MathUtil.isWithinBox(mouseX, mouseY, 0.0, 0.0, width, height)) {
            if (deltaY > 0.0) {
                this.configWidgets.moveTabsRight();
            } else if (deltaY < 0.0) {
                this.configWidgets.moveTabsLeft();
            }
        }
        return super.m_6050_(mouseX, mouseY, deltaY);
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.minecraft.f_91073_ != null && this.visible) {
            graphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, 839913488, 0x1000000);
        } else if (this.minecraft.f_91073_ == null) {
            Panorama.render(graphics, partialTick);
        }
        Tooltip.setVisible(this.visible);
        if (this.visible) {
            super.m_88315_(graphics, mouseX, mouseY, partialTick);
        }
    }

    public boolean isSavable() {
        return TweakPool.stream().filter(Tweak::isNotIgnored).anyMatch(TweakMeta::isAnyCacheSavable);
    }

    protected void saveConfig() {
        if (!this.isSavable()) {
            return;
        }
        TweakPool.stream().filter(Tweak::isNotIgnored).filter(TweakMeta::isAnyCacheSavable).forEach(Tweak::applyCacheAndSend);
        ConfigCache.save();
        AfterConfigSave.run();
    }

    protected void undoAndClose() {
        TweakPool.values().forEach(TweakMeta::sync);
        SCREEN_CACHE.push(this);
        super.m_7379_();
    }

    @Override
    public void m_7379_() {
        if (!this.isSavable()) {
            this.undoAndClose();
            return;
        }
        SCREEN_CACHE.push(this);
        MutableComponent title = Lang.Affirm.QUIT_TITLE.get(new Object[0]);
        MutableComponent body = Lang.Affirm.QUIT_BODY.get(new Object[0]);
        MutableComponent discard = Lang.Affirm.QUIT_DISCARD.get(new Object[0]);
        MutableComponent cancel = Lang.Affirm.QUIT_CANCEL.get(new Object[0]);
        class CancelConsumer
        implements BooleanConsumer {
            CancelConsumer() {
            }

            public void accept(boolean understood) {
                if (understood) {
                    ConfigScreen.this.undoAndClose();
                    ConfigScreen.this.minecraft.m_91152_(ConfigScreen.this.parentScreen);
                } else {
                    ConfigScreen.this.minecraft.m_91152_((Screen)ConfigScreen.this);
                    SCREEN_CACHE.pop(ConfigScreen.this);
                }
            }
        }
        ConfirmScreen confirmScreen = new ConfirmScreen((BooleanConsumer)new CancelConsumer(), (Component)title, (Component)body, (Component)discard, (Component)cancel);
        this.minecraft.m_91152_((Screen)confirmScreen);
    }
}

