/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mod.adrenix.nostalgic.client.gui.screen.WidgetManager;
import mod.adrenix.nostalgic.client.gui.screen.config.ConfigScreen;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.CategoryFilter;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.manage.ManageOverlay;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.list.DescriptionRow;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.list.GroupRow;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.list.RowProvider;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.list.TweakRow;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.tab.TabBuilder;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.tab.TabButton;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.input.GenericInput;
import mod.adrenix.nostalgic.client.gui.widget.input.GenericInputBuilder;
import mod.adrenix.nostalgic.client.gui.widget.list.AbstractRow;
import mod.adrenix.nostalgic.client.gui.widget.list.RowList;
import mod.adrenix.nostalgic.client.gui.widget.list.RowListBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorWidget;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.tweak.container.Container;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.tweak.factory.TweakPool;
import mod.adrenix.nostalgic.util.client.search.SearchTag;
import mod.adrenix.nostalgic.util.client.search.TweakDatabase;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.function.ForEachWithPrevious;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ConfigWidgets
implements WidgetManager {
    public static final int TAB_CONTROLLER_SIZE = 14;
    public static final int BOTTOM_OFFSET = 21;
    public static final int LIST_START_Y = 21;
    private String lastQuery;
    private final ConfigScreen configScreen;
    private final LinkedHashSet<TabButton> tabs = new LinkedHashSet();
    private final HashMap<Tweak<?>, CompletableFuture<TweakRow>> searchMap = new HashMap();
    private ButtonWidget manage;
    private ButtonWidget finish;
    private ButtonWidget filter;
    private ButtonWidget save;
    private ButtonWidget all;
    private ButtonWidget favorite;
    private ButtonWidget tabLeft;
    private ButtonWidget tabRight;
    private RowList rowList;
    private GenericInput search;
    private SeparatorWidget topSeparator;
    private SeparatorWidget bottomSeparator;
    private CategoryFilter categoryFilter;

    ConfigWidgets(ConfigScreen configScreen) {
        RowProvider.DEFAULT.use();
        this.configScreen = configScreen;
        this.lastQuery = "";
    }

    public GenericInput getSearch() {
        return this.search;
    }

    public RowList getRowList() {
        return this.rowList;
    }

    public ButtonWidget getAll() {
        return this.all;
    }

    public LinkedHashSet<TabButton> getTabs() {
        return this.tabs;
    }

    public ButtonWidget getTabLeft() {
        return this.tabLeft;
    }

    public ButtonWidget getTabRight() {
        return this.tabRight;
    }

    public ButtonWidget getFavorite() {
        return this.favorite;
    }

    public SeparatorWidget getTopSeparator() {
        return this.topSeparator;
    }

    public SeparatorWidget getBottomSeparator() {
        return this.bottomSeparator;
    }

    @Override
    public void init() {
        this.rowList = this.createRowList();
        this.save = this.createSaveButton();
        this.tabLeft = this.createTabLeft();
        this.tabRight = this.createTabRight();
        this.manage = this.createManageButton();
        this.favorite = this.createFavoriteButton();
        this.all = this.createAllButton();
        this.filter = this.createFilterButton();
        this.finish = this.createFinishButton();
        this.search = this.createSearch();
        this.topSeparator = this.createTopSeparator();
        this.bottomSeparator = this.createBottomSeparator();
        this.categoryFilter = new CategoryFilter(this.filter, this::resetSearchResults);
        Container.CATEGORIES.forEach(this::createTabFromCategory);
        this.createSearchMap();
        this.checkTabs();
        this.centerTabs();
        this.populateRowList();
        this.tabLeft.setTabOrderGroup(0);
        this.tabRight.setTabOrderGroup(0);
        this.tabs.forEach(tab -> tab.setTabOrderGroup(1));
        this.rowList.setTabOrderGroup(2);
        this.save.setTabOrderGroup(3);
        this.manage.setTabOrderGroup(4);
        this.favorite.setTabOrderGroup(5);
        this.all.setTabOrderGroup(6);
        this.filter.setTabOrderGroup(7);
        this.search.setTabOrderGroup(8);
        this.finish.setTabOrderGroup(9);
    }

    public void setQuery(String query) {
        this.search.setInput(query);
        this.updateSearchResults();
    }

    public String getQuery() {
        return this.search.getInput();
    }

    private void createSearchMap() {
        TweakPool.stream().forEach(tweak -> this.searchMap.put((Tweak<?>)tweak, CompletableFuture.supplyAsync(() -> (TweakRow)TweakRow.create(tweak, this.rowList).indent(0).build(), Util.m_183991_())));
    }

    private TweakRow getSearchRow(Tweak<?> tweak) {
        return this.searchMap.get(tweak).join();
    }

    private void addTab(TabButton tab) {
        this.configScreen.addWidget(tab);
        this.tabs.add(tab);
    }

    public void populateFromProvider() {
        for (RowProvider provider : RowProvider.values()) {
            if (!provider.isProviding()) continue;
            switch (provider) {
                case ALL: {
                    this.populateFromAll();
                    break;
                }
                case FAVORITE: {
                    this.populateFromFavorite();
                    break;
                }
                case DEFAULT: {
                    this.populateRowList();
                }
            }
            return;
        }
    }

    public void populateRowList() {
        if (!this.lastQuery.isEmpty()) {
            return;
        }
        RowProvider.DEFAULT.useAndThen(this.rowList::clear);
        Container.CATEGORIES.stream().filter(this.configScreen.getCategory()::equals).findFirst().ifPresent(this::populateFromCategory);
    }

    private void populateFromFavorite() {
        this.stopGivingSearchResults();
        this.populateFromPredicate(RowProvider.FAVORITE.useAndGetPredicate());
    }

    private void populateFromAll() {
        this.stopGivingSearchResults();
        this.populateFromPredicate(RowProvider.ALL.useAndGetPredicate());
    }

    private void populateFromCategory(Container category) {
        if (category.getDescription().isPresent()) {
            this.rowList.addBottomRow((AbstractRow)DescriptionRow.create(category, this.rowList).build());
        }
        category.getTweaks().stream().filter(Tweak::isTop).forEach(tweak -> this.rowList.addBottomRow((AbstractRow)TweakRow.create(tweak, this.rowList).build()));
        Container.GROUPS.stream().filter(group -> group.getParent().stream().anyMatch(parent -> parent.equals(category))).forEachOrdered(group -> this.rowList.addBottomRow((AbstractRow)GroupRow.create(group, this.rowList).build()));
        CollectionUtil.filterOut(category.getTweaks(), Tweak::isTop).forEach(tweak -> this.rowList.addBottomRow((AbstractRow)TweakRow.create(tweak, this.rowList).build()));
    }

    private void populateFromPredicate(Predicate<Tweak<?>> predicate) {
        this.rowList.clear();
        Container.CATEGORIES.forEach(category -> category.getTweaks().stream().filter(predicate).forEach(tweak -> this.rowList.addBottomRow((AbstractRow)TweakRow.create(tweak, this.rowList).build())));
        ArrayList<Container> matchedGroups = new ArrayList<Container>();
        ArrayList matchedFromCategory = new ArrayList();
        Container.GROUPS.stream().filter(Container::isGroup).filter(group -> group.getTweaks().stream().anyMatch(predicate)).forEachOrdered(matchedGroups::add);
        matchedGroups.forEach(group -> group.getGroupSetFromCategory().stream().filter(Container::isGroup).findFirst().ifPresent(matchedFromCategory::add));
        matchedFromCategory.stream().distinct().forEach(container -> this.rowList.addBottomRow((AbstractRow)GroupRow.create(container, this.rowList).build()));
    }

    private void populateFromSearch(String query) {
        if (this.search == null) {
            return;
        }
        if (query.isEmpty()) {
            if (ConfigScreen.SCREEN_CACHE.isPushed()) {
                ConfigScreen.SCREEN_CACHE.pop(this.configScreen);
            } else if (this.getQuery().isEmpty() && RowProvider.get() != RowProvider.DEFAULT) {
                this.populateFromProvider();
            }
            this.lastQuery = query;
            return;
        }
        if (query.equals(this.lastQuery)) {
            return;
        }
        this.lastQuery = query;
        this.rowList.clear();
        if (SearchTag.isInvalid(query)) {
            return;
        }
        if (RowProvider.get() != RowProvider.FAVORITE) {
            RowProvider.ALL.use();
        }
        this.findAndPopulateList(query);
    }

    public void populateFromQuery() {
        this.populateFromSearch(this.getQuery());
    }

    private void findAndPopulateList(String query) {
        for (Tweak tweak : TweakDatabase.getInstance().findValues(query, 0.08)) {
            if (!RowProvider.get().test(tweak) || !this.categoryFilter.test(tweak.getCategory())) continue;
            this.rowList.addBottomRow(this.getSearchRow(tweak));
        }
    }

    private void updateSearchResults() {
        if (this.lastQuery.isEmpty() || this.lastQuery.equals(this.getQuery())) {
            return;
        }
        this.lastQuery = "";
        this.populateFromQuery();
    }

    private void resetSearchResults() {
        if (this.getQuery().isEmpty()) {
            return;
        }
        this.lastQuery = "";
        this.populateFromQuery();
    }

    public void stopGivingSearchResults() {
        this.lastQuery = "";
    }

    private void createTabRightOf(DynamicWidget<?, ?> rightOf, Container category) {
        this.addTab((TabButton)((TabBuilder)TabButton.create(this.configScreen, category).pos(rightOf.getEndX() + 1, 1)).build());
    }

    private void createTabFromCategory(Container category) {
        Consumer<TabButton> createTabFromPrev = prevTab -> this.createTabRightOf((DynamicWidget<?, ?>)prevTab, category);
        Runnable createFirstTab = () -> this.createTabRightOf(this.tabRight, category);
        CollectionUtil.last(this.tabs).ifPresentOrElse(createTabFromPrev, createFirstTab);
    }

    private void checkTabs() {
        this.tabs.stream().filter(TabButton::isOverflow).forEach(TabButton::setHiddenRight);
    }

    private void setTabPositionFromPrev(TabButton prev, TabButton next) {
        next.m_252865_(prev.getEndX() + 1);
    }

    private void realignTabs() {
        this.tabs.stream().filter(TabButton::isVisible).findFirst().ifPresent(TabButton::setAtStartPosition);
        ForEachWithPrevious.create(this.tabs.stream().filter(TabButton::isVisible)).forEach(this::setTabPositionFromPrev).run();
        this.checkTabs();
    }

    private void centerTabs() {
        if (this.isTabOverflow()) {
            return;
        }
        int size = this.tabs.stream().mapToInt(DynamicWidget::m_5711_).sum() + this.tabs.size() - 1;
        int maxSize = this.configScreen.f_96543_;
        this.tabs.stream().findFirst().ifPresent(tab -> tab.m_252865_(Math.round(MathUtil.center(size, maxSize))));
        ForEachWithPrevious.create(this.tabs).forEach(this::setTabPositionFromPrev).run();
    }

    private void selectFirstTab() {
        this.tabs.stream().findFirst().ifPresent(TabButton::select);
        while (!this.isLeftSatisfied()) {
            this.moveTabsRight();
        }
    }

    private void selectLastTab() {
        CollectionUtil.last(this.tabs.stream()).ifPresent(TabButton::select);
        while (!this.isRightSatisfied()) {
            this.moveTabsLeft();
        }
    }

    public void selectTabRight() {
        ForEachWithPrevious.create(this.tabs).returnNextWhenPrev(TabButton::isSelected).run().ifPresentOrElse(TabButton::select, this::selectFirstTab);
        if (this.tabs.stream().anyMatch(TabButton::isRealignNeeded)) {
            this.moveTabsLeft();
        }
    }

    public void selectTabLeft() {
        ForEachWithPrevious.create(this.tabs).returnPrevWhenNext(TabButton::isSelected).run().ifPresentOrElse(TabButton::select, this::selectLastTab);
        if (this.tabs.stream().anyMatch(TabButton::isRealignNeeded)) {
            this.moveTabsRight();
        }
    }

    private boolean isTabOverflow() {
        return this.tabs.stream().anyMatch(TabButton::isOverflow) || this.tabs.stream().anyMatch(TabButton::isHiddenLeft);
    }

    private boolean isLeftSatisfied() {
        return CollectionUtil.first(this.tabs).filter(TabButton::isHiddenLeft).isEmpty();
    }

    private boolean isRightSatisfied() {
        return CollectionUtil.last(this.tabs).filter(TabButton::isHiddenRight).isEmpty();
    }

    public void moveTabsLeft() {
        if (this.isRightSatisfied()) {
            return;
        }
        this.tabs.stream().filter(TabButton::isVisible).findFirst().ifPresent(TabButton::setHiddenLeft);
        this.tabs.stream().filter(TabButton::isHiddenRight).findFirst().ifPresent(TabButton::setVisibleRight);
        this.realignTabs();
    }

    public void moveTabsRight() {
        if (this.isLeftSatisfied()) {
            return;
        }
        CollectionUtil.last(this.tabs.stream().filter(TabButton::isHiddenLeft)).ifPresent(TabButton::setVisibleLeft);
        CollectionUtil.last(this.tabs.stream().filter(TabButton::isVisible)).ifPresent(TabButton::setHiddenRight);
        this.realignTabs();
    }

    private ButtonWidget createTabLeft() {
        return ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create((Component)Component.m_237113_((String)"\u2190")).pos(1, 6)).size(14)).renderer(TabButton::arrowRenderer)).onPress(this::moveTabsRight)).visibleIf(this::isTabOverflow)).disableIf(this::isLeftSatisfied)).build(this.configScreen::addWidget);
    }

    private ButtonWidget createTabRight() {
        return ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create((Component)Component.m_237113_((String)"\u2192")).rightOf(this.tabLeft, 1)).size(14)).renderer(TabButton::arrowRenderer)).onPress(this::moveTabsLeft)).visibleIf(this::isTabOverflow)).disableIf(this::isRightSatisfied)).build(this.configScreen::addWidget);
    }

    private Component getEmptyMessage() {
        MutableComponent message = RowProvider.FAVORITE.isProviding() ? Lang.Listing.EMPTY_FAVORITES.get(new Object[0]) : Lang.Listing.NOTHING_FOUND.get(new Object[0]);
        if (this.search != null) {
            if (this.search.m_93696_()) {
                message = this.search.isProcessingInput() ? Lang.Listing.SEARCHING.get(new Object[0]) : Lang.Listing.NOTHING_FOUND.get(new Object[0]);
            }
            if (SearchTag.isInvalid(this.search.getInput())) {
                message = Lang.Input.INVALID_TAG.get(this.search.getInput());
            }
        }
        return message;
    }

    private RowList createRowList() {
        return ((RowListBuilder)((RowListBuilder)((RowListBuilder)RowList.create().pos(0, 21)).useHighlightsWhen(ModTweak.DISPLAY_ROW_HIGHLIGHT::fromCache).backgroundOpacity(ModTweak.MENU_BACKGROUND_OPACITY::fromCache).overrideHighlights(ModTweak.OVERRIDE_ROW_HIGHLIGHT::fromCache, ModTweak.ROW_HIGHLIGHT_OPACITY::fromCache).extendHeightToScreenEnd(23)).extendWidthToScreenEnd(0)).renderTopAndBottomDirt().emptyMessage(this::getEmptyMessage).build(this.configScreen::addWidget);
    }

    private TextureIcon getFinishIcon() {
        return this.configScreen.isSavable() ? Icons.RED_X : Icons.GREEN_CHECK;
    }

    private Component getFinishTitle() {
        return this.configScreen.isSavable() ? Lang.Vanilla.GUI_CANCEL.get(new Object[0]) : Lang.Vanilla.GUI_DONE.get(new Object[0]);
    }

    private ButtonWidget createFinishButton() {
        return ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().posY(this.configScreen.f_96544_ - 21)).onPress(this.configScreen::m_7379_)).icon(this::getFinishIcon)).title(this::getFinishTitle)).tooltip(this::getFinishTitle, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.FINISH, 45)).fromScreenEndX(1)).skipFocusOnClick()).useTextWidth()).padding(5)).build(this.configScreen::addWidget);
    }

    private ButtonWidget createSaveButton() {
        return ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.SAVE).pos(1, this.configScreen.f_96544_ - 21)).icon(Icons.SAVE_FLOPPY)).tooltip(Lang.Button.SAVE, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.SAVE, 45)).skipFocusOnClick()).useTextWidth()).padding(5)).onPress(this.configScreen::saveConfig)).enableIf(this.configScreen::isSavable)).build(this.configScreen::addWidget);
    }

    private ButtonWidget createManageButton() {
        return ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.MANAGE).onPress(() -> new ManageOverlay().open())).tooltip(Lang.Button.MANAGE, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.MANAGE, 45)).icon(Icons.MECHANICAL_TOOLS)).rightOf(this.save, 1)).skipFocusOnClick()).useTextWidth()).padding(5)).build(this.configScreen::addWidget);
    }

    private ButtonWidget createFavoriteButton() {
        return ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.FAVORITE).skipFocusOnClick()).useTextWidth()).padding(5)).icon(Icons.STAR_ON)).tooltip(Lang.Button.FAVORITE, 500L, TimeUnit.MILLISECONDS)).infoTooltip(RowProvider.FAVORITE::getInfoTooltip, 45)).disableIf(RowProvider.FAVORITE::isProviding)).onPress(this::populateFromFavorite)).rightOf(this.manage, 1)).build(this.configScreen::addWidget);
    }

    private ButtonWidget createAllButton() {
        return ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.SEE_ALL).padding(5)).useTextWidth()).skipFocusOnClick()).icon(Icons.BOOK_OPEN)).tooltip(Lang.Button.SEE_ALL, 500L, TimeUnit.MILLISECONDS)).infoTooltip(RowProvider.ALL::getInfoTooltip, 45)).disableIf(RowProvider.ALL::isProviding)).onPress(this::populateFromAll)).rightOf(this.favorite, 1)).build(this.configScreen::addWidget);
    }

    private ButtonWidget createFilterButton() {
        return ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.FILTER).skipFocusOnClick()).useTextWidth()).padding(5)).icon(Icons.FILTER)).tooltip(Lang.Tooltip.FILTER_SEARCH, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.FILTER_SEARCH_INFO, 45)).rightOf(this.all, 1)).onPress(() -> this.categoryFilter.open())).build(this.configScreen::addWidget);
    }

    private void resizeSearch(GenericInput search) {
        if (search.m_5711_() > 180) {
            return;
        }
        this.favorite.shrink();
        this.all.shrink();
        this.filter.shrink();
        ((GenericInputBuilder)search.getBuilder()).sync();
    }

    private GenericInput createSearch() {
        return ((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)GenericInput.create().icon(Icons.SEARCH)).whenEmpty(Lang.Input.SEARCH)).background(Color.OLIVE_BLACK, Color.OLIVE_BLACK)).border(Color.BLACK, Color.WHITE)).delayedResponse(350L)).maxLength(100)).searchShortcut()).rightOf(this.filter, 1)).extendWidthTo(this.finish, 1)).afterSync(this::resizeSearch)).whenFocused(this::populateFromQuery)).onInput(this::populateFromSearch)).build(this.configScreen::addWidget);
    }

    private SeparatorWidget createTopSeparator() {
        return ((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(Color.SILVER_CHALICE).visibleIf(() -> this.tabs.stream().filter(TabButton::isVisible).noneMatch(TabButton::isSelected))).extendWidthToScreenEnd(0)).height(1)).below(this.tabLeft, 0)).build(this.configScreen::addWidget);
    }

    private SeparatorWidget createBottomSeparator() {
        return ((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(Color.SILVER_CHALICE).extendWidthToScreenEnd(0)).height(1)).above(this.save, 1)).build(this.configScreen::addWidget);
    }
}

