/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config;

import java.util.HashSet;
import java.util.function.Consumer;
import mod.adrenix.nostalgic.client.gui.screen.config.ConfigScreen;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.list.GroupRow;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.list.RowProvider;
import mod.adrenix.nostalgic.client.gui.widget.list.AbstractRow;
import mod.adrenix.nostalgic.tweak.container.Category;
import mod.adrenix.nostalgic.tweak.container.Container;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.CollectionUtil;

class ScreenCache {
    Container category = Category.MOD;
    RowProvider rowProvider = RowProvider.get();
    final HashSet<Container> containers = new HashSet();
    boolean pushed = false;
    double scrollAmount = 0.0;
    String search = "";

    ScreenCache() {
    }

    public void reset() {
        this.category = Category.MOD;
        this.rowProvider = RowProvider.get();
        this.containers.clear();
        this.pushed = false;
        this.scrollAmount = 0.0;
        this.search = "";
    }

    public boolean isPushed() {
        return this.pushed;
    }

    public void push(ConfigScreen screen) {
        this.pushed = true;
        this.containers.clear();
        screen.getWidgetManager().getRowList().getRows().forEach((Consumer<AbstractRow<?, ?>>)((Consumer<AbstractRow>)this::saveOpenedGroups));
        this.search = screen.getWidgetManager().getQuery();
        this.scrollAmount = screen.getWidgetManager().getRowList().getScrollAmount();
        this.category = screen.getCategory();
        this.rowProvider = RowProvider.get();
    }

    public void pop(ConfigScreen screen) {
        if (!this.pushed) {
            return;
        }
        this.pushed = false;
        if (!this.search.isEmpty()) {
            screen.getWidgetManager().getSearch().setNonReactiveInput(this.search);
        }
        screen.setCategory(this.category);
        this.rowProvider.useAndThen(() -> screen.getWidgetManager().populateFromProvider());
        if (!this.search.isEmpty() && this.rowProvider == RowProvider.ALL) {
            screen.getWidgetManager().populateFromQuery();
        }
        this.openSavedGroups(screen);
        screen.getWidgetManager().getRowList().setScrollAmount(this.scrollAmount);
    }

    private void saveOpenedGroups(AbstractRow<?, ?> row) {
        ClassUtil.cast(row, GroupRow.class).stream().filter(GroupRow::isExpanded).map(GroupRow::getContainer).forEach(this.containers::add);
    }

    private void openSavedGroups(ConfigScreen screen) {
        if (this.containers.isEmpty()) {
            return;
        }
        int openedSize = this.containers.size();
        HashSet rows = new HashSet(screen.getWidgetManager().getRowList().getRows());
        CollectionUtil.fromCast(rows, GroupRow.class).filter(group -> this.containers.contains(group.getContainer())).forEachOrdered(group -> {
            this.containers.remove(group.getContainer());
            group.expand();
        });
        if (openedSize != this.containers.size()) {
            this.openSavedGroups(screen);
        }
    }
}

