/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.overlay.listing;

import java.util.List;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.overlay.types.state.SwitchGroup;
import mod.adrenix.nostalgic.client.gui.overlay.types.state.SwitchOverlay;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.tweak.listing.ItemRule;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.color.Gradient;
import mod.adrenix.nostalgic.util.common.data.Holder;
import mod.adrenix.nostalgic.util.common.function.BooleanConsumer;
import mod.adrenix.nostalgic.util.common.world.ItemFilter;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FilterOverlay {
    private final Runnable onPress;
    private final SwitchOverlay overlay;
    private final Holder<Boolean> tools = Holder.create(false);
    private final Holder<Boolean> items = Holder.create(false);
    private final Holder<Boolean> blocks = Holder.create(false);
    private final Holder<Boolean> edibles = Holder.create(false);
    private final List<Holder<Boolean>> holders = List.of(this.tools, this.items, this.blocks, this.edibles);

    public FilterOverlay(LayoutElement aboveOrBelow, Runnable onPress) {
        this.onPress = onPress;
        this.overlay = SwitchOverlay.create(aboveOrBelow);
        Overlay parent = this.overlay.get();
        SwitchGroup tools = SwitchGroup.create((WidgetHolder)parent, ItemRule.NO_TOOLS.getName(), ItemRule.NO_TOOLS.getInfo(), this.tools::get, this.set(this.tools));
        SwitchGroup items = SwitchGroup.create((WidgetHolder)parent, ItemRule.NO_ITEMS.getName(), ItemRule.NO_ITEMS.getInfo(), this.items::get, this.set(this.items));
        SwitchGroup blocks = SwitchGroup.create((WidgetHolder)parent, ItemRule.NO_BLOCKS.getName(), ItemRule.NO_BLOCKS.getInfo(), this.blocks::get, this.set(this.blocks));
        SwitchGroup edibles = SwitchGroup.create((WidgetHolder)parent, ItemRule.NO_EDIBLES.getName(), ItemRule.NO_EDIBLES.getInfo(), this.edibles::get, this.set(this.edibles));
        this.overlay.setGroups(List.of(tools, items, blocks, edibles));
        this.overlay.get().getBuilder().outlineColor(Color.WHITE).gradientBackground(Gradient.vertical(Color.ASPHALT_GRAY.fromAlpha(220), Color.DARK_BLUE.fromAlpha(220)));
    }

    public void open() {
        this.overlay.open();
    }

    private BooleanConsumer set(Holder<Boolean> holder) {
        return state -> {
            holder.set(state);
            this.onPress.run();
        };
    }

    public boolean isFiltered(Item item) {
        if (this.holders.stream().noneMatch(Holder::get)) {
            return false;
        }
        boolean isToolFiltered = ItemFilter.isToolLike(item) && this.tools.get() != false;
        boolean isItemFiltered = ItemFilter.isItemLike(item) && this.items.get() != false;
        boolean isBlockFiltered = ItemFilter.isBlockLike(item) && this.blocks.get() != false;
        boolean isEdibleFiltered = item.m_41472_() && this.edibles.get() != false;
        return isToolFiltered || isItemFiltered || isBlockFiltered || isEdibleFiltered;
    }

    public boolean isFiltered(ItemStack itemStack) {
        return this.isFiltered(itemStack.m_41720_());
    }
}

